<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Champions Montessori Academy
 * @version : 7.0
 * @developed by : GreatCoder Tech
 * @support : dreddavid150@gmail.com
 * @author url : https://web.facebook.com/dreddavid
 * @copyright : Reserved GreatCoder Technologies
 */

class Cmas_behaviour extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('exam_model');
        $this->load->model('exam_progress_model');
        $this->load->model('cmas_behaviour_model');
        $this->load->model('subject_model');
        $this->load->model('sms_model');
        if (!moduleIsEnabled('attendance')) {
            access_denied();
        }
    }

    public function index()
    {
        if (get_loggedin_id()) {
            redirect(base_url('dashboard'), 'refresh');
        } else {
            redirect(base_url(), 'refresh');
        }
    }

    // student submitted attendance all data are prepared and stored in the database here
public function cmas_behaviour_student_entry()
{
    // Permission check
    if (!get_permission('student_attendance', 'is_add')) {
        access_denied();
    }

    $branchID = $this->application_model->get_branch_id();

    // SEARCH MODE
    if ($this->input->post('search')) {

        // Validation rules
        if (is_superadmin_loggedin()) {
            $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
        }
        $this->form_validation->set_rules('class_id', translate('class'), 'required');
        $this->form_validation->set_rules('section_id', translate('section'), 'required');

        if ($this->form_validation->run() === true) {
            $classID   = $this->input->post('class_id');
            $sectionID = $this->input->post('section_id');
            $examID    = $this->input->post('exam_id');
            $sessionID = $this->input->post('session_id') ?: get_session_id(); // ✅ Fixed

            // Get exam details and student behaviour list
            $this->data['exam_details'] = $this->exam_model->getExamByID($examID);
            $this->data['cmasbehaviourlist'] = $this->cmas_behaviour_model->getCmasStudentBehaviour(
                $classID, $sectionID, $sessionID, $examID, $branchID
            );
        }
    }

    // SAVE MODE
    if ($this->input->post('save')) {
        $cmas_behaviour = $this->input->post('cmas_behaviour');

        if (!empty($cmas_behaviour) && is_array($cmas_behaviour)) {

            $this->db->trans_start();

            foreach ($cmas_behaviour as $value) {
                $arrayBehaviour = [
                    'enroll_id'          => $value['enroll_id'] ?? null,
                    'exam_id'            => $value['exam_id'] ?? null,
                    'class_id'           => $value['class_id'] ?? null,
                    'section_id'         => $value['section_id'] ?? null,
                    'session_id'         => $value['session_id'] ?? null,
                    'branch_id'          => $branchID,
                    'skilll_hand'        => $value['skilll_hand'] ?? null,
                    'beha_help'          => $value['beha_help'] ?? null,
                    'emotional_stability'=> $value['emotional_stability'] ?? null,
                    'nonverbal_skill'    => $value['nonverbal_skill'] ?? null,
                    'perseverance'       => $value['perseverance'] ?? null,
                    'attitude'           => $value['attitude'] ?? null,
                    'materials'          => $value['materials'] ?? null,
                    'neatness'           => $value['neatness'] ?? null,
                    'orderliness'        => $value['orderliness'] ?? null,
                    'punctuality'        => $value['punctuality'] ?? null,
                    'honesty'            => $value['honesty'] ?? null,
                    'politeness'         => $value['politeness'] ?? null,
                    'cooperation'        => $value['cooperation'] ?? null,
                    'leadership'         => $value['leadership'] ?? null,
                    'speaking'           => $value['speaking'] ?? null,
                    'teachers_comment'   => $value['teachers_comment'] ?? null,
                    'cmaskill1'          => $value['cmaskill1'] ?? null,
                    'cmaskill2'          => $value['cmaskill2'] ?? null,
                    'cmaskill3'          => $value['cmaskill3'] ?? null,
                    'cmaskill4'          => $value['cmaskill4'] ?? null,
                    'cmaskill5'          => $value['cmaskill5'] ?? null,
                    'cmaskill6'          => $value['cmaskill6'] ?? null,
                    'cmabehav1'          => $value['cmabehav1'] ?? null,
                    'cmabehav2'          => $value['cmabehav2'] ?? null,
                    'cmabehav3'          => $value['cmabehav3'] ?? null,
                    'cmabehav4'          => $value['cmabehav4'] ?? null,
                    'cmabehav5'          => $value['cmabehav5'] ?? null,
                    'cmabehav6'          => $value['cmabehav6'] ?? null,
                    'behavcontd1'        => $value['behavcontd1'] ?? null,
                    'behavcontd2'        => $value['behavcontd2'] ?? null,
                    'behavcontd3'        => $value['behavcontd3'] ?? null
                ];

                if (empty($value['cmas_behaviour_id'])) {
                    $this->db->insert('cmas_behaviour', $arrayBehaviour);
                } else {
                    $this->db->where('id', $value['cmas_behaviour_id']);
                    $this->db->update('cmas_behaviour', $arrayBehaviour);
                }
            }

            $this->db->trans_complete();

            if ($this->db->trans_status() === false) {
                set_alert('error', translate('an_error_occurred'));
            } else {
                set_alert('success', translate('information_has_been_updated_successfully'));
            }
        }

        redirect(current_url());
    }

    // Load view
    $this->data['branch_id'] = $branchID;
    $this->data['title']     = translate('Student Skills/Behaviour');
    $this->data['sub_page']  = 'cmas_behaviour/behaviour_student_entries';
    $this->data['main_menu'] = 'CMAS Behaviour Entries';
    $this->load->view('layout/index', $this->data);
}




    
    public function getWeekendsHolidays()
    {
        if (!get_permission('student_attendance', 'is_add')) {
            ajax_access_denied();
        }
        if ($_POST) {
            $branchID = $this->input->post('branch_id');
            $getWeekends = $this->application_model->getWeekends($branchID);
            $getHolidays = $this->attendance_model->getHolidays($branchID);
            echo json_encode(['getWeekends' => $getWeekends, 'getHolidays' => '["' . $getHolidays . '"]' ]);
        }
    }

    // employees submitted attendance all data are prepared and stored in the database here
    public function employees_entry()
    {
        if (!get_permission('employee_attendance', 'is_add')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if (isset($_POST['search'])) {
            if (is_superadmin_loggedin()) {
                $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
            }
            $this->form_validation->set_rules('staff_role', translate('role'), 'required');
            $this->form_validation->set_rules('date', translate('date'), 'trim|required|callback_check_weekendday|callback_check_holiday|callback_get_valid_date');
            if ($this->form_validation->run() == true) {
                $roleID = $this->input->post('staff_role');
                $date = $this->input->post('date');
                $this->data['date'] = $date;
                $this->data['attendencelist'] = $this->attendance_model->getStaffAttendence($roleID, $date, $branchID);
            }
        }
        $this->data['getWeekends'] = $this->application_model->getWeekends($branchID);
        if (isset($_POST['save'])) {
            $attendance = $this->input->post('attendance');
            $date = $this->input->post('date');
            foreach ($attendance as $key => $value) {
                $attStatus = (isset($value['status']) ? $value['status'] : "");
                $arrayAttendance = array(
                    'staff_id' => $value['staff_id'],
                    'status' => $attStatus,
                    'remark' => $value['remark'],
                    'date' => $date,
                    'branch_id' => $branchID,
                );
                if (empty($value['attendance_id'])) {
                    $this->db->insert('staff_attendance', $arrayAttendance);
                } else {
                    $this->db->where('id', $value['attendance_id']);
                    $this->db->update('staff_attendance', array('status' => $attStatus, 'remark' => $value['remark']));
                }
                // send student absent then sms
                if ($attStatus == 'A') {
                    $this->sms_model->send_sms($arrayAttendance, 3);
                }
            }
            set_alert('success', translate('information_has_been_updated_successfully'));
            redirect(current_url());
        }
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('employee_attendance');
        $this->data['sub_page'] = 'attendance/employees_entries';
        $this->data['main_menu'] = 'attendance';
        $this->load->view('layout/index', $this->data);
    }

    // exam submitted attendance all data are prepared and stored in the database here
    public function exam_entry()
    {
        if (!get_permission('exam_attendance', 'is_add')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if (isset($_POST['search'])) {
            if (is_superadmin_loggedin()) {
                $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
            }
            $this->form_validation->set_rules('exam_id', translate('exam'), 'required');
            $this->form_validation->set_rules('class_id', translate('class'), 'required');
            $this->form_validation->set_rules('section_id', translate('section'), 'required');
            $this->form_validation->set_rules('subject_id', translate('subject'), 'required');

            if ($this->form_validation->run() == true) {
                $classID = $this->input->post('class_id');
                $sectionID = $this->input->post('section_id');
                $examID = $this->input->post('exam_id');
                $subjectID = $this->input->post('subject_id');
                $this->data['class_id'] = $classID;
                $this->data['section_id'] = $sectionID;
                $this->data['exam_id'] = $examID;
                $this->data['subject_id'] = $subjectID;
                $this->data['attendencelist'] = $this->attendance_model->getExamAttendence($classID, $sectionID, $examID, $subjectID, $branchID);
            }
        }

        if (isset($_POST['save'])) {
            $attendance = $this->input->post('attendance');
            $subjectID = $this->input->post('subject_id');
            $examID = $this->input->post('exam_id');
            foreach ($attendance as $key => $value) {
                $attStatus = (isset($value['status']) ? $value['status'] : "");
                $arrayAttendance = array(
                    'student_id' => $value['student_id'],
                    'status' => $attStatus,
                    'remark' => $value['remark'],
                    'exam_id' => $examID,
                    'subject_id' => $subjectID,
                    'branch_id' => $branchID,
                );
                if (empty($value['attendance_id'])) {
                    $this->db->insert('exam_attendance', $arrayAttendance);
                } else {
                    $this->db->where('id', $value['attendance_id']);
                    $this->db->update('exam_attendance', array('status' => $attStatus, 'remark' => $value['remark']));
                }
                // send student absent then sms
                if ($attStatus == 'A') {
                    $this->sms_model->send_sms($arrayAttendance, 4);
                }
            }
            set_alert('success', translate('information_has_been_updated_successfully'));
            redirect(current_url());
        }
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('exam_attendance');
        $this->data['sub_page'] = 'attendance/exam_entries';
        $this->data['main_menu'] = 'attendance';
        $this->load->view('layout/index', $this->data);
    }

    // student attendance reports are produced here
    public function studentwise_report()
    {
        if (!get_permission('student_attendance_report', 'is_view')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if ($_POST) {
            $this->data['class_id'] = $this->input->post('class_id');
            $this->data['section_id'] = $this->input->post('section_id');
            $this->data['month'] = date('m', strtotime($this->input->post('timestamp')));
            $this->data['year'] = date('Y', strtotime($this->input->post('timestamp')));
            $this->data['days'] = cal_days_in_month(CAL_GREGORIAN, $this->data['month'], $this->data['year']);
            $this->data['studentlist'] = $this->attendance_model->getStudentList($branchID, $this->data['class_id'], $this->data['section_id']);
        }
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('student_attendance');
        $this->data['sub_page'] = 'attendance/student_report';
        $this->data['main_menu'] = 'attendance_report';
        $this->load->view('layout/index', $this->data);
    }

    public function student_classreport()
    {
        if (!get_permission('student_attendance_report', 'is_view')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if ($_POST) {
            if (is_superadmin_loggedin()) {
                $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
            }
            $this->form_validation->set_rules('date', translate('date'), 'trim|required|callback_get_valid_date');
            if ($this->form_validation->run() == true) {
                $this->data['date'] = $this->input->post('date');
                $this->data['attendancelist'] = $this->attendance_model->getDailyStudentReport($branchID, $this->data['date']);
            }
        }
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('student') . ' ' . translate('daily_reports');
        $this->data['sub_page'] = 'attendance/student_classreport';
        $this->data['main_menu'] = 'attendance_report';
        $this->load->view('layout/index', $this->data);
    }

    /* employees attendance reports are produced here */
    public function employeewise_report()
    {
        if (!get_permission('employee_attendance_report', 'is_view')) {
            access_denied();
        }

        if ($_POST) {
            $this->data['branch_id'] = $this->application_model->get_branch_id();
            $this->data['role_id'] = $this->input->post('staff_role');
            $this->data['month'] = date('m', strtotime($this->input->post('timestamp')));
            $this->data['year'] = date('Y', strtotime($this->input->post('timestamp')));
            $this->data['days'] = cal_days_in_month(CAL_GREGORIAN, $this->data['month'], $this->data['year']);
            $this->data['stafflist'] = $this->attendance_model->getStaffList($this->data['branch_id'], $this->data['role_id']);
        }
        $this->data['title'] = translate('employee_attendance');
        $this->data['sub_page'] = 'attendance/employees_report';
        $this->data['main_menu'] = 'attendance_report';
        $this->load->view('layout/index', $this->data);
    }

    /* student exam attendance reports are produced here */
    public function examwise_report()
    {
        if (!get_permission('exam_attendance_report', 'is_view')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if ($_POST) {
            $this->data['class_id'] = $this->input->post('class_id');
            $this->data['section_id'] = $this->input->post('section_id');
            $this->data['exam_id'] = $this->input->post('exam_id');
            $this->data['subject_id'] = $this->input->post('subject_id');
            $this->data['branch_id'] = $this->application_model->get_branch_id();
            $this->data['examreport'] = $this->attendance_model->getExamReport($this->data);
        }
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('exam_attendance');
        $this->data['sub_page'] = 'attendance/exam_report';
        $this->data['main_menu'] = 'attendance_report';
        $this->load->view('layout/index', $this->data);
    }

    public function get_valid_date($date)
    {
        $present_date = date('Y-m-d');
        $date = date("Y-m-d", strtotime($date));
        if ($date > $present_date) {
            $this->form_validation->set_message("get_valid_date", "Please Enter Correct Date");
            return false;
        } else {
            return true;
        }
    }

    public function check_holiday($date) {
        $branchID = $this->application_model->get_branch_id();
        $getHolidays = $this->attendance_model->getHolidays($branchID);
        $getHolidaysArray = explode('","', $getHolidays);

        if(!empty($getHolidaysArray)) {
            if(in_array($date, $getHolidaysArray)) {
                $this->form_validation->set_message('check_holiday','You have selected a holiday.');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function check_weekendday($date) {
        $branchID = $this->application_model->get_branch_id();
        $getWeekendDays = $this->attendance_model->getWeekendDaysSession($branchID);
        if(!empty($getWeekendDays)) {
            if(in_array($date, $getWeekendDays)) {
                $this->form_validation->set_message('check_weekendday', "You have selected a weekend date.");
                return FALSE;
            } else {
                return TRUE;
            }
        }
        return TRUE;
    }
}