<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Champions Montessori Academy
 * @version : 7.0
 * @developed by : GreatCoder Tech
 * @support : dreddavid150@gmail.com
 * @author url : https://web.facebook.com/dreddavid
 * @copyright : Reserved GreatCoder Technologies
 */

class Dashboard extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('dashboard_model');
    }

    public function index()
    {
        /* -------------------------------------------
         * STUDENT OR PARENT LOGIN
         * ------------------------------------------- */
        if (is_student_loggedin() || is_parent_loggedin()) {

            $studentID = 0;
            $parentID  = 0;

            // -------------------------
            // STUDENT LOGIN
            // -------------------------
            if (is_student_loggedin()) {

                $studentID = get_loggedin_user_id(); // first get student ID
                $parentID  = get_type_name_by_id('student', $studentID, 'parent_id');

                $this->data['title'] = translate('welcome_to') . " " . $this->session->userdata('name');
                $this->data['walletbalance'] = get_type_name_by_parent_id('parent_wallet', $parentID, 'balance');
            }

            // -------------------------
            // PARENT LOGIN
            // -------------------------
            elseif (is_parent_loggedin()) {

                $studentID = $this->session->userdata('myChildren_id');

                if (!empty($studentID)) {
                    // Has selected a child
                    $parentID = get_type_name_by_id('student', $studentID, 'parent_id');

                    $firstName = get_type_name_by_id('student', $studentID, 'first_name');
                    $this->data['title'] = $firstName . " - " . translate('dashboard');

                    $this->data['walletbalance'] = get_type_name_by_parent_id('parent_wallet', $parentID, 'balance');

                } else {
                    // No selected child (parent dashboard only)
                    $parentName = $this->session->userdata('name');

                    $this->data['title'] = translate('welcome_to') . " " . $parentName;
                    $this->data['walletbalance'] = get_type_name_by_parent_fullname('parent_wallet', $parentName, 'balance');
                }
            }

            $this->data['student_id'] = $studentID;
            $schoolID = get_loggedin_branch_id();
            $this->data['school_id'] = $schoolID;

            $this->data['sub_page'] = 'userrole/dashboard';
        }

        /* -------------------------------------------
         * ADMIN / STAFF DASHBOARD
         * ------------------------------------------- */
        else {

            if (is_superadmin_loggedin()) {

                if ($this->input->get('school_id')) {
                    $schoolID = $this->input->get('school_id');
                    $this->data['title'] = get_type_name_by_id('branch', $schoolID) . " " . translate('branch_dashboard');
                } else {
                    $schoolID = "";
                    $this->data['title'] = translate('all_branch_dashboard');
                }

            } else {
                $schoolID = get_loggedin_branch_id();
                $this->data['title'] = get_type_name_by_id('branch', $schoolID) . " " . translate('branch_dashboard');
            }

            $sqlMode = $this->application_model->getSQLMode();
            $this->data['sqlMode'] = $sqlMode;
            $this->data['school_id'] = $schoolID;

            if ($sqlMode == false) {
                $this->data['fees_summary'] = $this->dashboard_model->annualFeessummaryCharts($schoolID);
                $this->data['get_Daymonth'] = $this->dashboard_model->getDaymonth($schoolID);
            } else {
                $this->data['fees_summary'] = [
                    'total_fee'  => 0,
                    'total_paid' => 0,
                    'total_due'  => 0
                ];
            }

            // More dashboard data
            $this->data['student_by_class']        = $this->dashboard_model->getStudentByClass($schoolID);
            $this->data['income_vs_expense']       = $this->dashboard_model->getIncomeVsExpense($schoolID);
            $this->data['weekend_attendance']      = $this->dashboard_model->getWeekendAttendance($schoolID);
            $this->data['get_monthly_admission']   = $this->dashboard_model->getMonthlyAdmission($schoolID);
            $this->data['get_voucher']             = $this->dashboard_model->getVoucher($schoolID);
            $this->data['get_transport_route']     = $this->dashboard_model->get_transport_route($schoolID);
            $this->data['get_total_student']       = $this->dashboard_model->get_total_student($schoolID);
            $this->data['get_total_current_student'] = $this->dashboard_model->get_total_current_student($schoolID);
            $this->data['get_total_deactive_student'] = $this->dashboard_model->get_total_deactive_student($schoolID);
            $this->data['get_total_alumni_student']   = $this->dashboard_model->get_total_alumni_student($schoolID);

            $this->data['sub_page'] = 'dashboard/index';
        }

        /* -------------------------------------------
         * LOAD JS, CSS, AND VIEW
         * ------------------------------------------- */
        $language = 'en';
        $jsArray = array(
            'vendor/chartjs/chart.min.js',
            'vendor/echarts/echarts.common.min.js',
            'vendor/moment/moment.js',
            'vendor/fullcalendar/fullcalendar.js',
        );

        if ($this->session->userdata('set_lang') != 'english') {
            $language = $this->dashboard_model->languageShortCodes($this->session->userdata('set_lang'));
            $jsArray[] = "vendor/fullcalendar/locale/$language.js";
        }

        $this->data['headerelements'] = [
            'css' => [
                'vendor/fullcalendar/fullcalendar.css',
            ],
            'js' => $jsArray
        ];

        $this->data['language'] = $language;
        $this->data['main_menu'] = 'dashboard';

        $this->load->view('layout/index', $this->data);
    }
}
