<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Our_values extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('our_values_model');
        $this->data['headerelements'] = array(
            'css' => array('vendor/dropify/css/dropify.min.css'),
            'js' => array('vendor/dropify/js/dropify.min.js'),
        );
    }

    private function our_values_validation()
    {
        if (is_superadmin_loggedin()) {
            $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
        }
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('description', 'Description', 'trim|required');
        $this->form_validation->set_rules('icon', 'SVG Icon', 'trim|required');
    }

  public function index()
{
    // check access permission
    if (!get_permission('frontend_testimonial', 'is_view')) {
        access_denied();
    }

    if ($_POST) {
        if (!get_permission('frontend_testimonial', 'is_add')) {
            access_denied();
        }

        // Validation
        if (is_superadmin_loggedin()) {
            $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
        }
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('description', 'Description', 'trim|required');
        $this->form_validation->set_rules('icon', 'SVG Icon', 'trim|required');

        if ($this->form_validation->run() !== false) {
            // Save data
            $data = array(
                'branch_id'   => is_superadmin_loggedin() ? $this->input->post('branch_id') : $this->application_model->get_branch_id(),
                'title'       => $this->input->post('title'),
                'description' => $this->input->post('description'),
                'icon'        => $this->input->post('icon', false), // SVG code saved directly
                'created_by'  => get_loggedin_user_id()
            );

            $this->our_values_model->save($data);

            set_alert('success', translate('information_has_been_saved_successfully'));
            echo json_encode(array('status' => 'success'));
        } else {
            echo json_encode(array('status' => 'fail', 'error' => $this->form_validation->error_array()));
        }
        exit();
    }

    $this->data['our_valueslist'] = $this->app_lib->getTable('front_cms_our_values');
    $this->data['title'] = translate('frontend');
    $this->data['sub_page'] = 'frontend/our_values';
    $this->data['main_menu'] = 'frontend';
    $this->load->view('layout/index', $this->data);
}

    public function edit($id = '')
    {
        if (!get_permission('frontend_testimonial', 'is_edit')) {
            access_denied();
        }

        if ($_POST) {
            $this->our_values_validation();
            if ($this->form_validation->run() !== false) {
                $this->our_values_model->save($this->input->post());
                set_alert('success', translate('information_has_been_updated_successfully'));
                $url = base_url('frontend/our_values');
                $array = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'error' => $error);
            }

            echo json_encode($array);
            exit();
        }

        $this->data['our_values'] = $this->our_values_model->get('front_cms_our_values', array('id' => $id), true);
        $this->data['title'] = translate('frontend');
        $this->data['sub_page'] = 'frontend/our_values_edit';
        $this->data['main_menu'] = 'frontend';
        $this->load->view('layout/index', $this->data);
    }

    public function delete($id = '')
    {
        if (!get_permission('frontend_testimonial', 'is_delete')) {
            access_denied();
        }

        $query = $this->db->get_where('front_cms_our_values', array('id' => $id));
        if ($query->num_rows() > 0) {
            $this->db->where('id', $id);
            $this->db->delete('front_cms_our_values');
        }
    }


    public function check_image()
    {
        if ($this->input->post('our_values_id')) {
            if (!empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            }
        } else {
            if (isset($_FILES['photo']['name']) && !empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            } else {
                $this->form_validation->set_message('check_image', 'The Photo is required.');
                return false;
            }
        }
    }
}
