<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Marksheet_template_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getList()
    {
        $this->db->select('marksheet_template.*, branch.name as branchname');
        $this->db->from('marksheet_template');
        $this->db->join('branch', 'branch.id = marksheet_template.branch_id', 'left');

        if (!is_superadmin_loggedin()) {
            $this->db->where('marksheet_template.branch_id', get_loggedin_branch_id());
        }

        $this->db->order_by('marksheet_template.id', 'ASC');
        return $this->db->get()->result_array();
    }

    public function save($data)
    {

        $classIDs = isset($data['class_ids']) ? $data['class_ids'] : [];
        // Convert to JSON for storage
        $classIDsJson = !empty($classIDs) ? json_encode($classIDs) : null;
        $arrayLive = [
            'branch_id'             => $this->application_model->get_branch_id(),
            'name'                  => $data['marksheet_template_name'],
            'class_ids'   => $classIDsJson,
            'page_layout'           => $data['page_layout'],
            'photo_style'           => $data['photo_style'],
            'photo_size'            => empty($data['photo_size']) ? 100 : $data['photo_size'],
            'top_space'             => empty($data['top_space']) ? 0 : $data['top_space'],
            'bottom_space'          => empty($data['bottom_space']) ? 0 : $data['bottom_space'],
            'right_space'           => empty($data['right_space']) ? 0 : $data['right_space'],
            'left_space'            => empty($data['left_space']) ? 0 : $data['left_space'],

            'background'            => $this->fileupload('background_file', './uploads/marksheet/', $this->input->post('old_background_file')),
            'logo'                  => $this->fileupload('logo_file', './uploads/marksheet/', $this->input->post('old_logo_file')),
            'principal_signature'   => $this->fileupload('principal_signature_file', './uploads/marksheet/', $this->input->post('old_principal_signature_file')),
            'school_stamp'          => $this->fileupload('school_stamp_file', './uploads/marksheet/', $this->input->post('old_school_stamp_file')),

            'header_content'        => $this->input->post('header_content', false),
            'footer_content'        => $this->input->post('footer_content', false),

            'attendance_percentage' => isset($_POST['attendance_percentage']) ? 1 : 0,
            'grading_scale'         => isset($_POST['grading_scale']) ? 1 : 0,
            'class_position'        => isset($_POST['class_position']) ? 1 : 0,
            'section_position'      => isset($_POST['section_position']) ? 1 : 0,
            'cumulative_average'    => isset($_POST['cumulative_average']) ? 1 : 0,
            'class_average'         => isset($_POST['class_average']) ? 1 : 0,
            'subject_position'      => isset($_POST['subject_position']) ? 1 : 0,
            'remark'                => isset($_POST['remark']) ? 1 : 0,
            'result'                => isset($_POST['result']) ? 1 : 0,
            'signature'             => isset($_POST['signature']) ? 1 : 0,
        ];

        if (!isset($data['marksheet_template_id'])) {
            $this->db->insert('marksheet_template', $arrayLive);
        } else {
            $this->db->where('id', $data['marksheet_template_id']);
            $this->db->update('marksheet_template', $arrayLive);
        }
    }

    public function tagsList()
    {
        return [
            '{name}',
            '{gender}',
            '{student_username}',
            '{register_no}',
            '{father_name}',
            '{mother_name}',
            '{student_photo}',
            '{student_days}',
            '{student_present}',
            '{student_absent}',
            '{academic_session}',
            '{admission_date}',
            '{class}',
            '{section}',
            '{category}',
            '{caste}',
            '{religion}',
            '{blood_group}',
            '{birthday}',
            '{email}',
            '{mobileno}',
            '{present_address}',
            '{permanent_address}',
            '{exam_name}',
            '{principal_signature}',
            '{school_stamp}',
            '{print_date}',
            '{resumption_date}',
            '{principal_comment}',
            '{teacher_comment}',
            '{logo}',
            '{institute_name}',
            '{institute_email}',
            '{institute_address}',
            '{institute_mobile_no}'
        ];
    }

    public function tagsReplace($studentData = [], $template = [], $extendsData = [], $header_content = '')
    {
        // Strong protection
        $template     = is_array($template) ? $template : [];
        $studentData  = is_array($studentData) ? $studentData : [];

        $body         = $template[$header_content] ?? '';
        $photo_size   = $template['photo_size'] ?? 100;
        $photo_style  = $template['photo_style'] ?? 1;

        // Default safe values
        $defaults = [
            'name' => '',
            'gender' => '',
            'student_username' => '',
            'register_no' => '',
            'father_name' => '',
            'mother_name' => '',
            'photo' => '',
            'student_days' => '0',
            'student_present' => '0',
            'student_absent' => '0',
            'admission_date' => '',
            'class' => '',
            'section' => '',
            'category' => '',
            'caste' => '',
            'religion' => '',
            'blood_group' => '',
            'birthday' => '',
            'email' => '',
            'mobileno' => '',
            'present_address' => '',
            'permanent_address' => '',
            'principal_comment' => '',
            'teacher_comment' => '',
            'resumption_date' => '',
            'institute_name' => '',
            'institute_email' => '',
            'institute_address' => '',
            'institute_mobile_no' => '',
        ];

        $userDetails = array_merge($defaults, $studentData);

        // Replace tags
        foreach ($this->tagsList() as $tag) {

            $field = trim($tag, '{}');

            switch ($field) {

                case 'student_photo':
                    $img = '<img class="' . ($photo_style == 1 ? '' : 'rounded') .
                        '" src="' . get_image_url('student', $userDetails['photo']) .
                        '" height="' . $photo_size . '">';
                    $body = str_replace($tag, $img, $body);
                    break;

                case 'logo':
                    $body = str_replace(
                        $tag,
                        !empty($template['logo']) ?
                            '<img src="' . base_url('uploads/marksheet/' . $template['logo']) . '">' : '',
                        $body
                    );
                    break;

                case 'school_stamp':
    $body = str_replace($tag,
        !empty($template['school_stamp']) ?
        '<div style="position: absolute; bottom: 0px; right: 5px; width: 180px; height: 160px;">
            <img src="' . base_url('uploads/marksheet/' . $template['school_stamp']) . '"
                 style="width:180px; height:140px; display:block;">
         </div>'
        : '',
        $body
    );
    break;

                case 'principal_signature':
                    $body = str_replace(
                        $tag,
                        !empty($template['principal_signature']) ?
                            '<img src="' . base_url('uploads/marksheet/' . $template['principal_signature']) . '">' : '',
                        $body
                    );
                    break;

                case 'academic_session':
                    $body = str_replace($tag, $extendsData['schoolYear'] ?? '', $body);
                    break;

                case 'print_date':
                    $body = str_replace($tag, _d($extendsData['print_date'] ?? ''), $body);
                    break;

                case 'exam_name':
                    $body = str_replace($tag, $extendsData['exam_name'] ?? '', $body);
                    break;

                default:
                    $body = str_replace($tag, $userDetails[$field] ?? '', $body);
                    break;
            }
        }

        return $body;
    }

    public function getTemplate($templateID = '', $branchID = '')
    {
        return $this->db->where(['id' => $templateID, 'branch_id' => $branchID])
            ->get('marksheet_template')->row_array();
    }
}
