<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Our_classes_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Our_classes save and update function
    public function save($data)
    {
        $insert_our_classes = array(
            'branch_id' => $this->application_model->get_branch_id(),
            'title' => $data['title'],
            'subtitle' => $data['subtitle'],
            'description' => $data['description'],
            'created_by' =>  get_loggedin_user_id(),
            'image' => $this->upload_image(),
        );

        if (isset($data['our_classes_id']) && !empty($data['our_classes_id'])) {
            $this->db->where('id', $data['our_classes_id']);
            $this->db->update('front_cms_our_classes', $insert_our_classes);
        } else {
            $this->db->insert('front_cms_our_classes', $insert_our_classes);
        }
    }

    // upload home slider image
    public function upload_image()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/our_classes/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'user-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous Our_classes image
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }

public function get_image_url($file_path = '')
{
    $path = FCPATH . 'uploads/frontend/our_classes/' . $file_path; // absolute path on server
    if (empty($file_path) || !file_exists($path)) {
        $image_url = base_url('uploads/app_image/defualt.png');
    } else {
        $image_url = base_url('uploads/frontend/our_classes/' . $file_path);
    }
    return $image_url;
}


} 
