<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Our_values_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct(); 
    }

    // our_values save and update function
    public function save($data)
    {
        // Determine branch ID safely
        $branch_id = isset($data['branch_id']) && !empty($data['branch_id'])
            ? $data['branch_id']
            : $this->application_model->get_branch_id();

        $insert_data = array(
            'branch_id'   => $branch_id,
            'title'       => $data['title'],
            'description' => $data['description'],
            'icon'        => $data['icon'],
            'created_by'  => get_loggedin_user_id(),
        );

        if (isset($data['our_values_id']) && !empty($data['our_values_id'])) {
            // Update existing
            $this->db->where('id', $data['our_values_id']);
            $this->db->update('front_cms_our_values', $insert_data);
        } else {
            // Insert new
            $this->db->insert('front_cms_our_values', $insert_data);
        }
    }



    // upload home slider image
    public function upload_image()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/our_values/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'user-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous our_values image
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }

public function get_image_url($file_path = '')
{
    $path = FCPATH . 'uploads/frontend/our_values/' . $file_path; // absolute path on server
    if (empty($file_path) || !file_exists($path)) {
        $image_url = base_url('uploads/app_image/defualt.png');
    } else {
        $image_url = base_url('uploads/frontend/our_values/' . $file_path);
    }
    return $image_url;
}


} 
