<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Timeline_history_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct(); 
    }

    // our_values save and update function
    public function save($data)
    {
        // Determine branch ID safely
        $branch_id = isset($data['branch_id']) && !empty($data['branch_id'])
            ? $data['branch_id']
            : $this->application_model->get_branch_id();

        $insert_data = array(
            'branch_id'   => $branch_id,
            'title'       => $data['title'],
            'description' => $data['description'],
            'year_range' => $data['year_range'],
            'image' => $this->upload_image(),
            'created_by'  => get_loggedin_user_id(),
        );

        if (isset($data['timeline_history_id']) && !empty($data['timeline_history_id'])) {
            // Update existing
            $this->db->where('id', $data['timeline_history_id']);
            $this->db->update('front_cms_timeline_history', $insert_data);
        } else {
            // Insert new
            $this->db->insert('front_cms_timeline_history', $insert_data);
        }
    }



    // upload home slider image
    public function upload_image()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/timeline_history/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'user-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous our_values image
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }

public function get_image_url($file_path = '')
{
    $path = FCPATH . 'uploads/frontend/timeline_history/' . $file_path; // absolute path on server
    if (empty($file_path) || !file_exists($path)) {
        $image_url = base_url('uploads/app_image/defualt.png');
    } else {
        $image_url = base_url('uploads/frontend/timeline_history/' . $file_path);
    }
    return $image_url;
}


} 
