<?php $widget = (is_superadmin_loggedin() ? 3 : 4); ?>
<section class="panel">
	<header class="panel-heading">
		<h4 class="panel-title"><?=translate('select_ground')?></h4>
	</header>
	<?php echo form_open($this->uri->uri_string());?>
	<div class="panel-body">
		<div class="row mb-sm">
		<?php if (is_superadmin_loggedin() ): ?>
			<div class="col-md-3 mb-sm">
				<div class="form-group">
					<label class="control-label"><?=translate('branch')?> <span class="required">*</span></label>
					<?php
						$arrayBranch = $this->app_lib->getSelectList('branch');
						echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' onchange='getClassByBranch(this.value)' id='branchID'
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
					?>
				</div>
				<span class="error"><?=form_error('branch_id')?></span>
			</div>
		<?php endif; ?>
			<div class="col-md-<?php echo $widget; ?> mb-sm">
				<div class="form-group">
					<label class="control-label"><?=translate('class')?> <span class="required">*</span></label>
					<?php
						$arrayClass = $this->app_lib->getClass($branch_id);
						echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
					 	data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
					?>
					<span class="error"><?=form_error('class_id')?></span>
				</div>
			</div>
			<div class="col-md-<?php echo $widget; ?> mb-sm">
				<div class="form-group">
					<label class="control-label"><?=translate('section')?> <span class="required">*</span></label>
					<?php
						$arraySection = $this->app_lib->getSections(set_value('class_id'), false);
						echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id'
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
					?>
					<span class="error"><?=form_error('section_id')?></span>
				</div>
			</div>
			<div class="col-md-<?php echo $widget; ?> mb-sm">
				<div class="form-group <?php if (form_error('date')) echo 'has-error'; ?>">
					<label class="control-label"><?=translate('date')?> <span class="required">*</span></label>
					<div class="input-group">
						<input type="text" class="form-control" name="date" id="attDate" value="<?=set_value('date', date("Y-m-d"))?>" autocomplete="off"/>
						<span class="input-group-addon"><i class="icon-event icons"></i></span>
					</div>
					<span class="error"><?=form_error('date')?></span>
				</div>
			</div>
		</div>
	</div>
	<footer class="panel-footer">
		<div class="row">
			<div class="col-md-offset-10 col-md-2">
				<button type="submit" name="search" value="1" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?=translate('filter')?></button>
			</div>
		</div>
	</footer>

    <?php echo form_close(); ?>
</section>

<?php if (isset($attendencelist)): ?>
<section class="panel">
    <?php echo form_open($this->uri->uri_string()); ?>
    <?php echo form_hidden(['date' => $date, 'branch_id' => $branch_id]); ?>

    <header class="panel-heading">
        <h4 class="panel-title"><?=translate('students_list')?></h4>
    </header>

    <div class="panel-body">
        <div class="table-responsive mb-sm mt-xs">
            <table class="table table-bordered table-hover table-condensed mb-none">
                <thead>
                    <tr>
                        <th>#</th>
						<th><?=translate('Photo')?></th>
                        <th><?=translate('name')?></th>
                        
                        <th><?=translate('register_no')?></th>
                        <th><?=translate('morning')?></th>
                        <th><?=translate('afternoon')?></th>
                        <th><?=translate('remarks')?></th>
                    </tr>
                </thead>

                <tbody>
                <?php 
                $count = 1;
                if(count($attendencelist)) {
                    foreach ($attendencelist as $key => $row): 

                        $morning = isset($row['status_morning']) ? $row['status_morning'] : 'P';
                        $afternoon = isset($row['status_afternoon']) ? $row['status_afternoon'] : 'P';
                        $remark = isset($row['remark']) ? $row['remark'] : '';
                ?>

                    <tr>
                        <input type="hidden" name="attendance[<?=$key?>][attendance_id]" value="<?=$row['att_id']?>">
                        <input type="hidden" name="attendance[<?=$key?>][enroll_id]" value="<?=$row['enroll_id']?>">

                        <td><?=$count++?></td>
						 <td class="center"><img src="<?php echo get_image_url('student', $row['photo']); ?>" height="50"></td>
                        <td><?=$row['first_name'].' '.$row['last_name']?></td>
        
                        <td><?=$row['register_no']?></td>

                        <!-- Morning -->
                        <td>
                            <?php foreach(['P'=>'present','A'=>'absent','L'=>'late','HD'=>'half_day'] as $val => $label): ?>
                                <label class="radio-inline">
                                    <input type="radio" 
                                           name="attendance[<?=$key?>][status_morning]" 
                                           value="<?=$val?>"
                                           <?=$morning == $val ? 'checked' : ''?>>
                                    <?=translate($label)?>
                                </label>
                            <?php endforeach; ?>
                        </td>

                        <!-- Afternoon -->
                        <td>
                            <?php foreach(['P'=>'present','A'=>'absent','L'=>'late','HD'=>'half_day'] as $val => $label): ?>
                                <label class="radio-inline">
                                    <input type="radio" 
                                           name="attendance[<?=$key?>][status_afternoon]" 
                                           value="<?=$val?>"
                                           <?=$afternoon == $val ? 'checked' : ''?>>
                                    <?=translate($label)?>
                                </label>
                            <?php endforeach; ?>
                        </td>

                        <td>
                            <input type="text" name="attendance[<?=$key?>][remark]" 
                                   class="form-control" value="<?=$remark?>">
                        </td>
                    </tr>

                <?php endforeach;
                } else { ?>
                    <tr>
                        <td colspan="7" class="text-center text-danger">
                            <?=translate('no_information_available')?>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="panel-footer">
        <div class="row">
            <div class="col-md-offset-10 col-md-2">
                <button type="submit" class="btn btn-default btn-block" name="save" value="1">
                    <i class="fas fa-plus-circle"></i> <?=translate('save')?>
                </button>
            </div>
        </div>
    </div>

    <?php echo form_close(); ?>
</section>
<?php endif; ?>

<script>
var dayOfWeekDisabled = "<?php echo $getWeekends ?>";

$(document).ready(function () {
    $("#attDate").datepicker({
        orientation: 'bottom',
        todayHighlight: true,
        autoclose: true,
        format: 'yyyy-mm-dd',
        daysOfWeekDisabled: dayOfWeekDisabled,
        datesDisabled: ["<?php echo $getHolidays ?>"],
    });
});

$('#branchID').change(function() {
    $.post(base_url + "attendance/getWeekendsHolidays",
    { branch_id: $(this).val() },
    function (data) {
        $('#attDate').val("");
        $('#attDate').datepicker('setDaysOfWeekDisabled', data.getWeekends);
        $('#attDate').datepicker('setDatesDisabled', JSON.parse(data.getHolidays));
    }, "json");
});
</script>
