<?php $widget = (is_superadmin_loggedin() ? 3 : 4); ?>
<section class="panel">
	<header class="panel-heading">
		<h4 class="panel-title"><?=translate('select_ground')?></h4>
	</header>
	<?php echo form_open($this->uri->uri_string());?>
			<div class="panel-body">
				<div class="row mb-sm">
				<?php if (is_superadmin_loggedin() ): ?>
					<div class="col-md-3 mb-sm">
						<div class="form-group"> 
							<label class="control-label"><?=translate('branch')?> <span class="required">*</span></label>
							<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
							?>
						</div>
					</div>
				<?php endif; ?>
					<div class="col-md-<?=$widget?> mb-sm">
						<div class="form-group">
							<label class="control-label"><?=translate('academic_year')?> <span class="required">*</span></label>
							<?php
								$arrayYear = array("" => translate('select'));
								$years = $this->db->get('schoolyear')->result();
								foreach ($years as $year){
									$arrayYear[$year->id] = $year->school_year;
								}
								echo form_dropdown("session_id", $arrayYear, set_value('session_id', get_session_id()), "class='form-control' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-<?=$widget?> mb-sm">
						<div class="form-group">
							<label class="control-label"><?=translate('exam')?> <span class="required">*</span></label>
							<?php
								
								if(!empty($branch_id)){
									$arrayExam = array("" => translate('select'));
									$exams = $this->db->get_where('exam', array('branch_id' => $branch_id,'session_id' => get_session_id()))->result();
									foreach ($exams as $exam){
										$arrayExam[$exam->id] = $this->application_model->exam_name_by_id($exam->id);
									}
								} else {
									$arrayExam = array("" => translate('select_branch_first'));
								}
								echo form_dropdown("exam_id", $arrayExam, set_value('exam_id'), "class='form-control' id='exam_id' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-3 mb-sm">
						<div class="form-group">
							<label class="control-label"><?=translate('class')?> <span class="required">*</span></label>
							<?php
								$arrayClass = $this->app_lib->getClass($branch_id);
								echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
								required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-<?=$widget?>">
						<div class="form-group">
							<label class="control-label"><?=translate('section')?> <span class="required">*</span></label>
							<?php
								$arraySection = $this->app_lib->getSections(set_value('class_id'));
								echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
				</div>
			</div>
	<footer class="panel-footer">
		<div class="row">
			<div class="col-md-offset-10 col-md-2">
				<button type="submit" name="search" value="1" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?=translate('filter')?></button>
			</div>
		</div>
	</footer>
	<?php echo form_close();?>
</section>

<?php if (isset($cmasbehaviourlist)): ?>
	<section class="panel appear-animation" data-appear-animation="<?=$global_config['animations'] ?>" data-appear-animation-delay="100">
		<?php
			echo form_open($this->uri->uri_string());
			$data = array( 'branch_id' => $branch_id);
			echo form_hidden($data);
		?>
		<header class="panel-heading">
			<h4 class="panel-title"><i class="fas fa-users"></i> <?=translate('Student Behaviour /Teacher Comment')?></h4>
		</header>
		<div class="panel-body">
			
			
			
			<div class="row">
				<div class="col-md-12">
					<div class="table-responsive mb-sm mt-xs">
						<table class="table table-bordered table-hover table-condensed mb-none">
							<thead>
								<tr>
									<!-- <th>#</th> -->
									<th class="no-sort"><?=translate('photo')?></th>
									<th><?=translate('NAME')?></th>
									<th><?=translate('GENDER')?></th>
									<th><?=translate('SKILLS')?></th>
									<th><?=translate('5')?></th>
									<th><?=translate('4')?></th>
									<th><?=translate('3')?></th>
									<th><?=translate('2')?></th>
									<th><?=translate('1')?></th>
									
									<th><?=translate(' Behaviour')?></th>
									<th><?=translate('5')?></th>
									<th><?=translate('4')?></th>
									<th><?=translate('3')?></th>
									<th><?=translate('2')?></th>
									<th><?=translate('1')?></th>

									<th><?=translate('BEHAVIOUR CONTD')?></th>
									<th><?=translate('5')?></th>
									<th><?=translate('4')?></th>
									<th><?=translate('3')?></th>
									<th><?=translate('2')?></th>
									<th><?=translate('1')?></th>
								</tr>
							</thead>
							<tbody>
								<?php
								$count = 1; 
								if(count($cmasbehaviourlist)) {
									foreach ($cmasbehaviourlist as $key => $row):
										?>
								<tr >
									<input type="hidden" name="cmas_behaviour[<?=$key?>][exam_id]" value="<?php echo $exam_details->id; ?>">
									<input type="hidden" name="cmas_behaviour[<?=$key?>][cmas_behaviour_id]" value="<?=$row['btt_id']?>" >
									<input type="hidden" name="cmas_behaviour[<?=$key?>][enroll_id]" value="<?=$row['enroll_id']?>" >
									<input type="hidden" name="cmas_behaviour[<?=$key?>][student_id]" value="<?=$row['student_id']?>" >
									<!-- <td><?php echo $count++; ?></td> -->
									<td class="center"><img src="<?php echo get_image_url('student', $row['photo']); ?>" height="50"></td>
									<td><?php echo $row['first_name'] . ' ' . $row['last_name']; ?></td>
									<td><?php echo $row['gender']; ?></td>
									<td>Handwriting</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
							                 <?php $cmaskill5 = $row['behav_cmaskill1']; ?><input type="radio" value="5" <?php echo ($cmaskill5 == '5') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill1]" id="skillwrit">
											<label for="skillwrit"></label>
											<input type="hidden" value="Handwriting" name="cmas_behaviour[<?=$key?>][skilll_hand]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmaskill4 = $row['behav_cmaskill1']; ?><input type="radio" value="4" <?php echo ($cmaskill4 == '4') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill1]" id="skillwrit">
											<label for="skillwrit"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmaskill3 = $row['behav_cmaskill1']; ?><input type="radio" value="3" <?php echo ($cmaskill3 == '3') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill1]" id="skillwrit">
											<label for="skillwrit"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmaskill2 = $row['behav_cmaskill1']; ?><input type="radio" value="2" <?php echo ($cmaskill2 == '2') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill1]" id="skillwrit">
											<label for="skillwrit"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmaskill1 = $row['behav_cmaskill1']; ?><input type="radio" value="1" <?php echo ($cmaskill1 == '1') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill1]" id="skillwrit">
											<label for="skillwrit"></label>
										</div>
										
									</td>

									<td>Helping Others</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmastar5 = $row['behav_cmaskill2']; ?><input type="radio" value="5" <?php echo ($cmastar5 == '5') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill2]" id="helping5">
											
											<label for="helping5"></label>
											<input type="hidden" value="Helping Others" name="cmas_behaviour[<?=$key?>][beha_help]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmastar4 = $row['behav_cmaskill2']; ?><input type="radio" value="4" <?php echo ($cmastar4 == '4') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill2]" id="helping4">
											<label for="helping4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmastar3 = $row['behav_cmaskill2']; ?><input type="radio" value="3" <?php echo ($cmastar3 == '3') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill2]" id="helping3">
											<label for="helping3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmastar2 = $row['behav_cmaskill2']; ?><input type="radio" value="2" <?php echo ($cmastar2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill2]" id="helping2">
											<label for="helping2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $cmastar1 = $row['behav_cmaskill2']; ?><input type="radio" value="1" <?php echo ($cmastar1 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill2]" id="helping1">
											<label for="helping1"></label>
										</div>
										
									</td>

									<td>Emotional Stability</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd5 = $row['behav_cmaskill3']; ?><input type="radio" value="5" <?php echo ($contd5 == '5') ? "checked" : "" ; ?>  name="cmas_behaviour[<?=$key?>][cmaskill3]" id="beha7">
											
											<label for="beha7"></label>
											<input type="hidden" value="Emotional Stability" name="cmas_behaviour[<?=$key?>][emotional_stability]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd4 = $row['behav_cmaskill3']; ?><input type="radio" value="4" <?php echo ($contd4 == '4') ? "checked" : "" ; ?>   name="cmas_behaviour[<?=$key?>][cmaskill3]" id="beha7">
											<label for="beha7"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd3 = $row['behav_cmaskill3']; ?><input type="radio" value="3" <?php echo ($contd3 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill3]" id="beha7">
											<label for="beha7"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill3']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill3]" id="beha7">
											<label for="beha7"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd1 = $row['behav_cmaskill3']; ?><input type="radio" value="1" <?php echo ($contd1 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill3]" id="beha7">
											<label for="beha7"></label>
										</div>
										
									</td>
									
								</tr>


								<tr>
									
									<td></td>
									<td></td>
									<td></td>
									<td>Nonverbal Skill</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $behavskill5 = $row['behav_cmaskill4']; ?><input type="radio" value="5" <?php echo ($behavskill5 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill4]" id="skill2">
											
											<label for="skill2"></label>
											<input type="hidden" value="Nonverbal Skill" name="cmas_behaviour[<?=$key?>][nonverbal_skill]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $behavskill4 = $row['behav_cmaskill4']; ?><input type="radio" value="4" <?php echo ($behavskill4 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill4]" id="skill2">
											<label for="skill2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $behavskill3 = $row['behav_cmaskill4']; ?><input type="radio" value="3" <?php echo ($behavskill3 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill4]" id="skill2">
											<label for="skill2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $behavskill2 = $row['behav_cmaskill4']; ?><input type="radio" value="2" <?php echo ($behavskill2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill4]" id="skill2">
											<label for="skill2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $behavskill1 = $row['behav_cmaskill4']; ?><input type="radio" value="5" <?php echo ($behavskill1 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill4]" id="skill2">
											<label for="skill2"></label>
										</div>
										
									</td>

									<td>Perseverance</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill5']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill5]" id="beha2">
											
											<label for="beha2"></label>
											<input type="hidden" value="Perseverance" name="cmas_behaviour[<?=$key?>][perseverance]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill5']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill5]" id="beha2">
											<label for="beha2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill5']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill5]" id="beha2">
											<label for="beha2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill5']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill5]" id="beha2">
											<label for="beha2"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill5']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill5]" id="beha2">
											<label for="beha2"></label>
										</div>
										
									</td>


									<td>Attitude to Work</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill6']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill6]" id="beha8">
											<label for="beha8"></label>
											<input type="hidden" value="Attitude to Work" name="cmas_behaviour[<?=$key?>][attitude]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill6']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill6]" id="beha8">
											<label for="beha8"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill6']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill6]" id="beha8">
											<label for="beha8"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill6']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill6]" id="beha8">
											<label for="beha8"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmaskill6']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmaskill6]" id="beha8">
											<label for="beha8"></label>
										</div>
										
									</td>


									
								</tr>

								<tr>
									
									<td></td>
									<td></td>
									<td></td>
									<td>Material/Tool Handling</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav1']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav1]" id="skill3">
											
											<label for="skill3"></label>
											<input type="hidden" value="Material/Tool Handling" name="cmas_behaviour[<?=$key?>][materials]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav1']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav1]" id="skill3">
											<label for="skill3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav1']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav1]" id="skill3">
											<label for="skill3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav1']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav1]" id="skill3">
											<label for="skill3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav1']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav1]" id="skill3">
											<label for="skill3"></label>
										</div>
										
									</td>

									<td>Neatness</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav2']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav2]" id="beha3">
											
											<label for="beha3"></label>
											<input type="hidden" value="Neatness" name="cmas_behaviour[<?=$key?>][neatness]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav2']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav2]" id="beha3">
											<label for="beha3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav2']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav2]" id="beha3">
											<label for="beha3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav2']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav2]" id="beha3">
											<label for="beha3"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav2']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav2]" id="beha3">
											<label for="beha3"></label>
										</div>
										
									</td>


									<td>Orderliness</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav3']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav3]" id="beha9">
											<label for="beha9"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav3']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav3]" id="beha9">
											<label for="beha9"></label>
											<input type="hidden" value="Orderliness" name="cmas_behaviour[<?=$key?>][orderliness]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav3']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav3]" id="beha9">
											<label for="beha9"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav3']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav3]" id="beha9">
											<label for="beha9"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav3']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav3]" id="beha9">
											<label for="beha9"></label>
										</div>
										
									</td>
									
								</tr>


								<tr>
									
									<td></td>
									<td></td>
									<td></td>
									<td>Punctuality</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav4']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav4]" id="skill4">
											
											<label for="skill4"></label>
											<input type="hidden" value="Punctuality" name="cmas_behaviour[<?=$key?>][punctuality]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav4']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav4]" id="skill4">
											<label for="skill4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav4']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav4]" id="skill4">
											<label for="skill4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav4']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav4]" id="skill4">
											<label for="skill4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav4']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav4]" id="skill4">
											<label for="skill4"></label>
										</div>
										
									</td>

									<td>Honesty</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav5']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav5]" id="beha4">
											
											<label for="beha4"></label>
											<input type="hidden" value="Honesty" name="cmas_behaviour[<?=$key?>][honesty]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav5']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav5]" id="beha4">
											<label for="beha4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav5']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav5]" id="beha4">
											<label for="beha4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav5']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav5]" id="beha4">
											<label for="beha4"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav5']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav5]" id="beha4">
											<label for="beha4"></label>
										</div>
										
									</td>
									<td colspan="6"> <div style="width: 100%;">
										<label for="teachers_comment">Teachers Comment</label>
										<input type="text" style="width: 100%;" value="<?=$row['behav_teachers_comment']?>" name="cmas_behaviour[<?=$key?>][teachers_comment]" id="teachers_comment">
											
										</div></td>
									
									
								</tr>

								<tr>
									
									<td></td>
									<td></td>
									<td></td>
									<td>Politeness</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav6']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav6]" id="skill5">
											
											<label for="skill5"></label>
											<input type="hidden" value="Politeness" name="cmas_behaviour[<?=$key?>][politeness]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav6']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav6]" id="skill5">
											<label for="skill5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav6']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav6]" id="skill5">
											<label for="skill5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav6']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav6]" id="skill5">
											<label for="skill5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_cmabehav6']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][cmabehav6]" id="skill5">
											<label for="skill5"></label>
										</div>
										
									</td>

									<td>Cooperation</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd1']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd1]" id="beha5">
											
											<label for="beha5"></label>
											<input type="hidden" value="Cooperation" name="cmas_behaviour[<?=$key?>][cooperation]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd1']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd1]" id="beha5">
											<label for="beha5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd1']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd1]" id="beha5">
											<label for="beha5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd1']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd1]" id="beha5">
											<label for="beha5"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd1']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd1]" id="beha5">
											<label for="beha5"></label>
										</div>
										
									</td>
									
								</tr>

								<tr>
									
									<td></td>
									<td></td>
									<td></td>
									<td>Leadership</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd2']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd2]" id="skill6">
											
											<label for="skill6"></label>
											<input type="hidden" value="Leadership" name="cmas_behaviour[<?=$key?>][leadership]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd2']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd2]" id="skill6">
											<label for="skill6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd2']; ?><input type="radio" value="3" <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd2]" id="skill6">
											<label for="skill6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd2']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd2]" id="skill6">
											<label for="skill6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd2']; ?><input type="radio" value="1" <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd2]" id="skill6">
											<label for="skill6"></label>
										</div>
										
									</td>

									<td>Speaking</td>

									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd3']; ?><input type="radio" value="5" <?php echo ($contd2 == '5') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd3]" id="beha6">
											
											<label for="beha6"></label>
											<input type="hidden" value="Speaking" name="cmas_behaviour[<?=$key?>][speaking]">
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd3']; ?><input type="radio" value="4" <?php echo ($contd2 == '4') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd3]" id="beha6">
											<label for="beha6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd3']; ?><input type="radio" value="3"  <?php echo ($contd2 == '3') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd3]" id="beha6">
											<label for="beha6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd3']; ?><input type="radio" value="2" <?php echo ($contd2 == '2') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd3]" id="beha6">
											<label for="beha6"></label>
										</div>
										
									</td>
									<td>
										<div class="radio-custom radio-success radio-inline mt-xs">
											<?php $contd2 = $row['behav_behavcontd3']; ?><input type="radio" value="1"  <?php echo ($contd2 == '1') ? "checked" : "" ; ?> name="cmas_behaviour[<?=$key?>][behavcontd3]" id="beha6">
											<label for="beha6"></label>
										</div>
										
									</td>
									
								</tr>



									

									<tr>
									
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								</tr>
								<tr>
									
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								</tr>
									<?php 
								endforeach;
							} else {
								echo '<tr><td colspan="6"><h5 class="text-danger text-center">'.translate('no_information_available').'</td></tr>';
							} ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<div class="panel-footer">
			<div class="row">
				<div class="col-md-offset-10 col-md-2">
					<button type="submit" class="btn btn-default btn-block" name="save" value="1">
						<i class="fas fa-plus-circle"></i> <?=translate('save')?>
					</button>
				</div>
			</div>
		</div>
		<?php echo form_close();?>
	</section>
<?php endif; ?>

<script type="text/javascript">
	$(document).ready(function () {
		$('#branch_id').on("change", function() {
			var branchID = $(this).val();
			getClassByBranch(branchID);
			getExamByBranch(branchID);
		});
	});
</script>