<style>
	.status-present {
		background-color: #11ff49ff;
		/* light green */
		border-radius: 4px;
		padding: 2px 6px;
	}

	.status-absent {
		background-color: #fb0418ff;
		/* light red */
		border-radius: 4px;
		color: #000;
		padding: 2px 6px;
	}

	.status-not-offered {
		background-color: #f5c422ff;
		/* light yellow */
		color: #000;
		border-radius: 4px;
		padding: 2px 6px;
	}
</style>

<?php $widget = (is_superadmin_loggedin() ? 2 : 3); ?>
<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<?php echo form_open($this->uri->uri_string(), array('class' => 'validate')); ?>
			<header class="panel-heading">
				<h4 class="panel-title"><?= translate('select_ground') ?></h4>
			</header>
			<div class="panel-body">
				<div class="row mb-sm">
					<?php if (is_superadmin_loggedin()): ?>
						<div class="col-md-2 mb-sm">
							<div class="form-group">
								<label class="control-label"><?= translate('branch') ?> <span class="required">*</span></label>
								<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
								?>
							</div>
						</div>
					<?php endif; ?>
					<div class="col-md-<?php echo $widget; ?> mb-sm">
						<div class="form-group">
							<label class="control-label"><?= translate('exam') ?> <span class="required">*</span></label>
							<?php
							if (isset($branch_id)) {
								$arrayExam = array("" => translate('select'));
								$exams = $this->db->get_where('exam', array('branch_id' => $branch_id, 'session_id' => get_session_id()))->result();
								foreach ($exams as $row) {
									$arrayExam[$row->id] = $this->application_model->exam_name_by_id($row->id);
								}
							} else {
								$arrayExam = array("" => translate('select_branch_first'));
							}
							echo form_dropdown("exam_id", $arrayExam, set_value('exam_id'), "class='form-control' id='exam_id' required data-plugin-selectTwo
								data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-3 mb-sm">
						<div class="form-group">
							<label class="control-label"><?= translate('class') ?> <span class="required">*</span></label>
							<?php
							$arrayClass = $this->app_lib->getClass($branch_id);
							echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
								required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-<?php echo $widget; ?> mb-sm">
						<div class="form-group">
							<label class="control-label"><?= translate('section') ?> <span class="required">*</span></label>
							<?php
							$arraySection = $this->app_lib->getSections(set_value('class_id'), false);
							echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-group">
							<label class="control-label"><?= translate('subject') ?> <span class="required">*</span></label>
							<?php
							if (!empty(set_value('class_id'))) {
								$arraySubject = array("" => translate('select'));
								$query = $this->subject_model->getSubjectByClassSection(set_value('class_id'), set_value('section_id'));
								$subjects = $query->result_array();
								foreach ($subjects as $row) {
									$subjectID = $row['subject_id'];
									$arraySubject[$subjectID] = $row['subjectname'];
								}
							} else {
								$arraySubject = array("" => translate('select_class_first'));
							}
							echo form_dropdown("subject_id", $arraySubject, set_value('subject_id'), "class='form-control' id='subject_id' required
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
				</div>
			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-offset-10 col-md-2">
						<button type="submit" name="search" value="1" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?= translate('filter') ?></button>
					</div>
				</div>
			</footer>
			<?php echo form_close(); ?>
		</section>

		<?php if (isset($student)): ?>
			<section class="panel appear-animation" data-appear-animation="<?php echo $global_config['animations']; ?>" data-appear-animation-delay="100">
				<?php echo form_open('exam/mark_save', array('class' => 'frm-submit-msg'));
				$data = array(
					'class_id' => $class_id,
					'section_id' => $section_id,
					'exam_id' => $exam_id,
					'subject_id' => $subject_id,
					'session_id' => get_session_id(),
					'branch_id' => $branch_id
				);
				echo form_hidden($data);
				?>
				<header class="panel-heading">
					<h4 class="panel-title"><i class="fas fa-users"></i> <?= translate('mark_entries') ?></h4>
				</header>
				<div class="panel-body">
					<div class="mb-sm">
						<button type="button" class="btn btn-success btn-sm" onclick="markAllStatus('present')">All Present</button>
						<button type="button" class="btn btn-danger btn-sm" onclick="markAllStatus('absent')">All Absent</button>
						<button type="button" class="btn btn-warning btn-sm" onclick="markAllStatus('not_offered')">All Not Offered</button>
					</div>

					<?php if (!empty($student) && !empty($timetable_detail)) { ?>
						<div class="table-responsive mt-md mb-lg">
							<table class="table table-bordered table-condensed mb-none">
								<thead>
									<tr>
										<th><?= translate('sl') ?></th>
										<th><?= translate('student_name') ?></th>
										<th><?= translate('category') ?></th>
										<th><?= translate('register_no') ?></th>
										
										<th>Attendance</th>

										<?php
										$distributions = json_decode($timetable_detail['mark_distribution'], true);
										foreach ($distributions as $i => $value) {
										?>
											<th><?php
												$data = array(
													'max_mark_' .  $i => $value['full_mark'],
												);
												echo form_hidden($data);
												echo get_type_name_by_id('exam_mark_distribution', $i) . " (" . $value['full_mark'] . ")"
												?></th>
										<?php } ?>
									</tr>
								</thead>
								<tbody>
									<?php
									$count = 1;
									foreach ($student as $key => $row):
									?>
										<tr>
											<input type="hidden" name="mark[<?= $key ?>][student_id]" value="<?= $row['student_id'] ?>">
											<td><?php echo $count++; ?></td>
											<td><?php echo $row['first_name'] . ' ' . $row['last_name']; ?></td>
											<td><?php echo get_type_name_by_id('student_category', $row['category_id']); ?></td>
											<td><?php echo $row['register_no']; ?></td>
											
											<td>
												<span class="status-label status-present">
													<label class="i-checks">
														<input type="radio"
															name="mark[<?= $key ?>][subject_status]"
															value="present"
															<?= ($row['subject_status'] == 'present' || empty($row['subject_status'])) ? 'checked' : '' ?>>
														<i></i> Present
													</label>
												</span>

												<span class="status-label status-absent mt-xs">
													<label class="i-checks">
														<input type="radio"
															name="mark[<?= $key ?>][subject_status]"
															value="absent"
															<?= ($row['subject_status'] == 'absent') ? 'checked' : '' ?>>
														<i></i> Absent
													</label>
												</span>

												<span class="status-label status-not-offered mt-xs">
													<label class="i-checks">
														<input type="radio"
															name="mark[<?= $key ?>][subject_status]"
															value="not_offered"
															<?= ($row['subject_status'] == 'not_offered') ? 'checked' : '' ?>>
														<i></i> Not Offered
													</label>
												</span>
											</td>





											<?php
											$getDetails = [];
											if (!empty($row['get_mark'])) {
												$getDetails = json_decode($row['get_mark'], true);
											}
											foreach ($distributions as $id => $ass) {
												$existMark = isset($getDetails[$id]) ? $getDetails[$id]  : '';
											?>
												<td class="min-w-sm">
													<div class="form-group">
														<input type="text" class="form-control" autocomplete="off" name="mark[<?= $key ?>][assessment][<?= $id ?>]" value="<?= $existMark ?>">
														<span class="error"></span>
													</div>
												</td>
											<?php } ?>
										</tr>
									<?php endforeach; ?>
								</tbody>
							</table>
						</div>
					<?php } else {
						echo '<div class="alert alert-subl mt-md text-center">' . translate('no_information_available') . '</div>';
					} ?>
				</div>
				<div class="panel-footer">
					<div class="row">
						<div class="col-md-offset-10 col-md-2">
							<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
								<i class="fas fa-plus-circle"></i> <?= translate('save') ?>
							</button>
						</div>
					</div>
				</div>
				<?php echo form_close(); ?>
			</section>
		<?php endif; ?>
	</div>
</div>

<script type="text/javascript">
	$(document).ready(function() {
		$('#branch_id').on('change', function() {
			var branchID = $(this).val();
			getClassByBranch(branchID);
			getExamByBranch(branchID);
			$('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
		});

		$('#section_id').on('change', function() {
			var classID = $('#class_id').val();
			var sectionID = $(this).val();
			$.ajax({
				url: base_url + 'subject/getByClassSection',
				type: 'POST',
				data: {
					classID: classID,
					sectionID: sectionID
				},
				success: function(data) {
					$('#subject_id').html(data);
				}
			});
		});
	});

function markAllStatus(status) {
    $('input[type=radio][name^="mark"]').each(function() {
        let key = $(this).closest('tr').find('input[name^="mark"]').first().attr('name').match(/\d+/)[0];

        // Set the corresponding radio
        $('input[name="mark[' + key + '][subject_status]"][value="' + status + '"]').prop('checked', true);

        // Update marks based on status
        toggleStatus(key);

        // Update row color
        updateRowColor(key);
    });
}



	function toggleStatus(key) {
		// get selected status for this student
		let status = $('input[name="mark[' + key + '][subject_status]"]:checked').val();

		// if present, marks editable; otherwise readonly
		let readonly = (status != 'present');

		$('input[name^="mark[' + key + '][assessment]"]').each(function() {
			$(this).prop('readonly', readonly);
			if (status == 'absent') {
				$(this).val('0'); // absent score = 0
			}
			if (status == 'not_offered') {
				$(this).val(''); // not_offered clears marks
			}
		});
	}


	function updateRowColor(key) {
		let status = $('input[name="mark[' + key + '][subject_status]"]:checked').val();
		let $row = $('input[name^="mark[' + key + '][subject_status]"]').closest('td');

		$row.find('.status-label').removeClass('active-label');
		$row.find('.status-present, .status-absent, .status-not-offered').css('opacity', 0.5);

		if (status == 'present') {
			$row.find('.status-present').css('opacity', 1);
		} else if (status == 'absent') {
			$row.find('.status-absent').css('opacity', 1);
		} else if (status == 'not_offered') {
			$row.find('.status-not-offered').css('opacity', 1);
		}
	}

	// Trigger color change on status change
	$(document).on('change', 'input[type=radio][name^="mark"]', function() {
		let key = $(this).closest('tr').find('input[name^="mark"]').first().attr('name').match(/\d+/)[0];
		toggleStatus(key);
		updateRowColor(key);
	});

	// Initialize on page load
	$(document).ready(function() {
		$('input[type=radio][name^="mark"]').each(function() {
			let key = $(this).closest('tr').find('input[name^="mark"]').first().attr('name').match(/\d+/)[0];
			updateRowColor(key);
		});
	});


	// trigger on status change
	$(document).on('change', 'input[type=radio][name^="mark"]', function() {
		let key = $(this).closest('tr').find('input[name^="mark"]').first().attr('name').match(/\d+/)[0];
		toggleStatus(key);
	});

	// initialize on page load
	$(document).ready(function() {
		$('input[type=radio][name^="mark"]').each(function() {
			let key = $(this).closest('tr').find('input[name^="mark"]').first().attr('name').match(/\d+/)[0];
			toggleStatus(key);
		});

		// allow only numbers in mark fields
		$('input[name^="mark"][name*="[assessment]"]').on('input', function() {
			this.value = this.value.replace(/[^0-9.]/g, '');
		});
	});
</script>