<?php $marksheet_template = $this->marksheet_template_model->getTemplate($templateID, $branchID); ?>


<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Playwrite+DE+VA+Guides&family=Playwrite+GB+J+Guides:ital@0;1&family=Playwrite+US+Trad+Guides&display=swap" rel="stylesheet">
<style type="text/css">
	@media print {
		.pagebreak {
			page-break-before: always;
		}

		.table-bordered>thead>tr>th,
		.table-bordered>tbody>tr>th,
		.table-bordered>tfoot>tr>th,
		.table-bordered>thead>tr>td,
		.table-bordered>tbody>tr>td,
		.table-bordered>tfoot>tr>td {
			border-color: #000 !important;
			padding: 1px;
		}
	}

	@media print {

    @page {
        size: A4;
        margin: 10mm;
    }

    html, body {
        width: 210mm;
        height: 297mm;
        margin: 0;
        padding: 0;
    }

    .print-student-page {
        page-break-after: always;
        break-after: page;
        width: 100%;
    }

    .print-student-page:last-child {
        page-break-after: auto;
        break-after: auto;
    }

    table, tr, td, th {
        page-break-inside: avoid !important;
        break-inside: avoid !important;
    }
}


	.mark-container {
		background: #fff;
		width: 100%;
		position: relative;
		z-index: 2;
		margin: 0 auto;
		padding: 10px 10px;
		border: 2px dotted #000;
	}

	table {
		border-collapse: collapse;
		border: 1px solid black;
		margin: 0 auto;
		white-space: normal;
		font-size: 10px;
	}

	td {

		font-size: 10px;
	}

	th {
		font-size: 10px;
	}


	input[type=checkbox] {
		padding: 20px;
		background: green;
	}


	.background {
		position: absolute;
		z-index: 0;
		width: 100%;
		height: 100%;
		<?php if (empty($marksheet_template['background'])) { ?>background: #fff;
		<?php } else { ?>background-image: url("<?= base_url('uploads/marksheet/' . $marksheet_template['background']) ?>") !important;
		background-repeat: no-repeat !important;
		background-size: 100% 100% !important;
		<?php } ?>
	}
</style>

<?php
$extINTL = extension_loaded('intl');
if (!empty($student_array)) {
	foreach ($student_array as $sc => $studentID) {
		$result = $this->exam_model->AdmingetStudentReportCard($studentID, $examID, $sessionID, $class_id, $section_id);
		$student = $result['student'];
		$getMarksList = $result['exam'];

		$rankDetail = $this->db->where(array('exam_id ' => $examID, 'enroll_id  ' => $student['enrollID']))->get('exam_rank')->row();
		$getExam = $this->db->where(array('id' => $examID))->get('exam')->row_array();
		$schoolYear = get_type_name_by_id('schoolyear', $sessionID, 'school_year');



		$extendsData = [];
		$extendsData['print_date'] = $print_date;
		$extendsData['resume_date'] = $resume_date;
		$extendsData['schoolYear'] = $schoolYear;
		$extendsData['exam_name'] = $getExam['name'];
		$extendsData['teacher_comments'] = empty($rankDetail->teacher_comments) ? '' : $rankDetail->teacher_comments;
		$extendsData['principal_comments'] = empty($rankDetail->principal_comments) ? '' : $rankDetail->principal_comments;


		$header_content = $this->marksheet_template_model->tagsReplace($student, $marksheet_template, $extendsData, 'header_content');
		$footer_content = $this->marksheet_template_model->tagsReplace($student, $marksheet_template, $extendsData, 'footer_content');


?>



		<?php
		$is_alumni = 0;
		$this->db->select('e.class_id,e.session_id,e.student_id, e.is_alumni');
		$this->db->from('enroll as e');

		$this->db->join('student', 'student.id = e.student_id', 'inner');
		$this->db->where('e.session_id', $sessionID);
		$this->db->where('e.is_alumni', $is_alumni);
		$this->db->where('e.class_id', $student['class_id']);
		$getTotalClass = $this->db->get()->num_rows();
		?>
		<div id="printArea">
			<div class="print-student-page">
    <!-- ONE STUDENT RESULT ONLY -->
		<div style="position: relative; width: 100%; height: 100%;">
			<div class="background"></div>
			<div class="mark-container">
				<?php echo $header_content ?>
				<table class="table table-condensed table-bordered mt-lg">

					<thead>

						<tr>
							<th>Subjects</th>
							<?php
							$markDistribution = json_decode($getExam['mark_distribution'], true);
							foreach ($markDistribution as $id) {
							?>
								<th style="font-size:12px; font-weight:700"><?php echo get_type_name_by_id('exam_mark_distribution', $id)  ?></th>
							<?php } ?>
							<?php if ($getExam['type_id'] == 1) { ?>
								<?php if ($getExam['term_id'] == 1) { ?>
									<th style="font-size:12px; font-weight:700">1st Term</th>

								<?php } ?>

								<?php if ($getExam['term_id'] == 2) { ?>
									<th style="font-size:12px; font-weight:700">2nd Term</th>

								<?php } ?>

								<?php if ($getExam['term_id'] == 3) { ?>
									<th style="font-size:12px; font-weight:700">3rd Term</th>

								<?php } ?>


							<?php } elseif ($getExam['type_id'] == 2) { ?>
								<th>Grade</th>
								<th>Avrg</th>
								<th>Remark</th>
							<?php } elseif ($getExam['type_id'] == 3) { ?>
								<?php if ($getExam['term_id'] == 1) { ?>
									<th style="font-size:12px; font-weight:700">1st Term</th>

								<?php } ?>

								<?php if ($getExam['term_id'] == 2) { ?>
									<th style="font-size:12px; font-weight:700">2nd Term</th>

								<?php } ?>

								<?php if ($getExam['term_id'] == 3) { ?>
									<th style="font-size:12px; font-weight:700">3rd Term</th>

								<?php } ?>
								<th style="font-size:12px; font-weight:700">Avrg</th>
								<th style="font-size:12px; font-weight:700">Grade</th>
								<th style="font-size:12px; font-weight:700">Remark</th>
								<th style="font-size:12px; font-weight:700"> Pos</th>
							<?php } ?>
						</tr>

					</thead>
					<tbody>
						<?php
						$colspan = count($markDistribution) + 1;
						$total_grade_point = 0;
						$grand_obtain_marks = 0;
						$grand_full_marks = 0;
						$result_status = 1;
						$validSubjectsCount = 0; // Count subjects for GPA
						foreach ($getMarksList as $row) {

							// Skip not_offered subjects completely
							if ($row['subject_status'] == 'not_offered') {
								continue;
							}

							$validSubjectsCount++; // Only count present/absent subjects for GPA
						?>
							<tr>

								<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none; font-weight:700" <?php } ?> valign="middle" width="35%"><?= $row['subject_name'] ?></td>



								<?php
								$total_obtain_marks = 0;
								$total_full_marks = 0;
								$fullMarkDistribution = json_decode($row['mark_distribution'], true);
								$obtainedMark = json_decode($row['get_mark'], true);
								foreach ($fullMarkDistribution as $i => $val) {
									$obtained_mark = floatval($obtainedMark[$i]);
									$fullMark = floatval($val['full_mark']);
									$passMark = floatval($val['pass_mark']);
									if ($obtained_mark < $passMark) {
										$result_status = 0;
									}

									$total_obtain_marks += $obtained_mark;
									$obtained = $row['subject_status'] == 'not_offered' ? 'Absent' : $obtained_mark;
									$total_full_marks += $fullMark;
								?>
									<?php if ($getExam['type_id'] == 1 || $getExam['type_id'] == 3) { ?>
										<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;font-size:12px; font-weight:700" <?php } ?> valign="middle">
											<?php
											if ($row['subject_status'] == 'not_offered') {
												echo 'Absent';
											} else {
												echo $obtained_mark;
											}
											?>
										</td>
									<?php }
									if ($getExam['type_id'] == 2) { ?>
										<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;display:none;font-size:12px; font-weight:700" <?php } ?> valign="middle">
											<?php
											if ($row['subject_status'] == 'not_offered') {
												echo 'Absent';
											} else {
												$percentage_grade = ($obtained_mark * 100) / $fullMark;
												$grade = $this->exam_model->getExam_grade($percentage_grade, $getExam['branch_id']);
												echo $grade['name'];
											}
											?>
										</td>
									<?php } ?>
								<?php
								}
								$grand_obtain_marks += $total_obtain_marks;
								$grand_full_marks += $total_full_marks;
								?>
								<?php if ($getExam['type_id'] == 1 || $getExam['type_id'] == 3) { ?>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;font-size:12px; font-weight:700" <?php } ?> valign="middle"><?= $total_obtain_marks ?></td>
								<?php }
								if ($getExam['type_id'] == 2) {
									$colspan += 1;
									$percentage_grade = ($total_obtain_marks * 100) / $total_full_marks;
									$grade = $this->exam_model->getExam_grade($percentage_grade, $getExam['branch_id']);
									$total_grade_point += $grade['grade_point'];

									$grand_obtain_marks += $subTotalObtain;
									$grand_full_marks += $subTotalFull;
								?>



									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?php echo $this->exam_model->getExamClassAverage($examID, $sessionID, $row['subject_id']); ?></td>


									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?= $grade['name'] ?></td>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?= $grade['remark'] ?></td>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?php echo $this->exam_model->getSubjectPosition($student['class_id'], $student['section_id'],  $getExam, $sessionID, $row['subject_id'], $total_obtain_marks); ?></td>
								<?php }
								if ($getExam['type_id'] == 3) {
									$colspan += 2;
									$percentage_grade = ($total_obtain_marks * 100) / $total_full_marks;
									$grade = $this->exam_model->getExam_grade($percentage_grade, $getExam['branch_id']);
									$total_grade_point += $grade['grade_point'];
								?>

									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?php echo $this->exam_model->getExamClassAverage($examID, $sessionID, $row['subject_id']); ?></td>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?= $grade['name'] ?></td>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?= $grade['remark'] ?></td>
									<td <?php if ($row['subject_status'] == 'not_offered') { ?> style="display:none;" <?php } ?> valign="middle"><?php echo $this->exam_model->getSubjectPosition($student['class_id'], $student['section_id'],  $getExam, $sessionID, $row['subject_id'], $total_obtain_marks); ?></td>


								<?php } ?>
							</tr>
						<?php } ?>





						<?php

						if ($getExam['type_id'] == 1 || $getExam['type_id'] == 3) { ?>
							<tr class="text-weight-semibold">
								<td valign="top">GRAND TOTAL :</td>
								<td valign="top" colspan="<?= $colspan ?>"><?= $grand_obtain_marks; ?>
								</td>
							</tr>

							<?php if ($extINTL == true) { ?>

							<?php } ?>
						<?php } ?>




						<?php


						if ($getExam['type_id'] == 2) { ?>
							<tr class="text-weight-semibold">
								<td valign="top">GPA :</td>
								<td valign="top" colspan="<?= $colspan + 1 ?>"><?= $validSubjectsCount > 0 ? number_format(($total_grade_point / $validSubjectsCount), 2, '.', '') : '0.00' ?></td>
							</tr>
						<?php }
						if ($getExam['type_id'] == 3) { ?>
							<tr class="text-weight-semibold">
								<td valign="top">GPA :</td>
								<td valign="top" colspan="<?= $colspan ?>"><?= $validSubjectsCount > 0 ? number_format(($total_grade_point / $validSubjectsCount), 2, '.', '') : '0.00' ?></td>
							</tr>
						<?php } ?>







					</tbody>
				</table>



				<table class="table  table-bordered">
					<tbody>
						<tr class="text-weight-semibold">
							<td valign="top" colspan="3" style="text-align:left">PROGRESSIVE CUMMULATIVE EVALUATION : <span style="padding-left:70px"> <?= $grand_obtain_marks; ?></span></td>
							<td></td>
							<?php if ($marksheet_template['class_position'] == 1) { ?>
								<td valign="top" colspan="4" style="font-size:12px; font-weight:700">POSITION IN CLASS: <span><?= $student['clrank'] ?> OUT <?= $getTotalClass ?> </span></td>
								<td></td>
							<?php } ?>

							<td> Average :</td>
							<td> <?php $percentage = ($grand_obtain_marks * 100) / $grand_full_marks;
									echo number_format($percentage, 2, '.', '') ?></td>
							<td>Subject Enroll:</td>
							<td style="font-size:13px; font-weight:700; padding:0px 2px;"><?php echo  count($getMarksList) ?></td>
							<td></td>

						</tr>

						<?php
						$is_alumni = 0;
						$this->db->select('e.class_id,e.section_id,e.student_id,e.is_alumni');
						$this->db->from('enroll as e');
						$this->db->join('student', 'student.id = e.student_id', 'inner');
						$this->db->where('e.session_id', $sessionID);
						$this->db->where('e.is_alumni', $is_alumni);
						$this->db->where('e.section_id', $student['section_id']);
						$getTotalSection = $this->db->get()->num_rows();
						?>

						<tr class="text-weight-semibold">
							<td valign="top" colspan="3"></td>
							<td></td>
							<?php if ($marksheet_template['section_position'] == 1) { ?>
								<td valign="top" colspan="4" style="font-size:12px; font-weight:700">POSITION IN SECTION: <span><?= $student['secrank'] ?> OUT <?= $getTotalSection ?> </span></td>
								<td></td> <?php } ?>
							<?php
							if ($marksheet_template['attendance_percentage'] == 1) {
								$year = explode('-', $schoolYear);
								$getTotalWorking = $this->db->where(array('enroll_id' => $student['enrollID'], 'year(date)' => $year[0]))->get('student_attendance')->num_rows();
								$getTotalAttendance = $this->db->where(array('enroll_id' => $student['enrollID'], 'status' => 'P', 'year(date)' => $year[0]))->get('student_attendance')->num_rows();
								$attenPercentage = empty($getTotalWorking) ? '0.00' : ($getTotalAttendance * 100) / $getTotalWorking;


							?>
						<tr>
							<th colspan="2" class="text-center" style="font-size: 12px; font-weight:700">ATTENDANCE</th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
						</tr>
						<tr>
							<th style="width: 25%;">No. of working days</th>
							<td> <?= $getTotalWorking ?></td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<th style="width: 25%;">No. of days attended</th>
							<td> <?= $getTotalAttendance ?></td>
							<td></td>
							<td></td>
						</tr>
					<?php } ?>
					</tr>
					</tr>



					</tbody>

				</table>



				<table class="table table-bordered">
					<thead style="font-weight:bolder">
						<tr style="background-color:#000;">
							<th style="font-size:12px; font-weight:700">LEGEND:</th>
							<th></th>
							<th style="font-size:12px; font-weight:700">SKILLS</th>
							<th>5</th>
							<th>4</th>
							<th>3</th>
							<th>2</th>
							<th>1</th>
							<th></th>
							<th style="font-size:12px; font-weight:700">BEHAVIOUR</th>
							<th>5</th>
							<th>4</th>
							<th>3</th>
							<th>2</th>
							<th>1</th>
							<th></th>
							<th style="font-size:12px; font-weight:700">BEHAVIOUR CONTD</th>
							<th>5</th>
							<th>4</th>
							<th>3</th>
							<th>2</th>
							<th>1</th>
						</tr>
					</thead>
					<tbody>
						<?php
						$skills = [
							['label' => 'Handwriting', 'key' => 'behav_cmaskill1'],
							['label' => 'Helping Others', 'key' => 'behav_cmaskill2'],
							['label' => 'Emotional Stability', 'key' => 'behav_cmaskill3'],
							['label' => 'Nonverbal Skill', 'key' => 'behav_cmaskill4'],
							['label' => 'Perseverance', 'key' => 'behav_cmaskill5'],
							['label' => 'Attitude to Work', 'key' => 'behav_cmaskill6'],
						];

						$behaviour = [
							['label' => 'Material/Tool Handling', 'key' => 'behav_cmabehav1'],
							['label' => 'Neatness', 'key' => 'behav_cmabehav2'],
							['label' => 'Orderliness', 'key' => 'behav_cmabehav3'],
							['label' => 'Punctuality', 'key' => 'behav_cmabehav4'],
							['label' => 'Honesty', 'key' => 'behav_cmabehav5'],
							['label' => 'Politeness', 'key' => 'behav_cmabehav6'],
						];

						$behaviour_contd = [
							['label' => 'Cooperation', 'key' => 'behav_behavcontd1'],
							['label' => 'Leadership', 'key' => 'behav_behavcontd2'],
							['label' => 'Speaking', 'key' => 'behav_behavcontd3'],
						];

						$levels = ['5', '4', '3', '2', '1'];

						// Get maximum number of rows
						$maxRows = max(count($skills), count($behaviour), count($behaviour_contd));

						for ($i = 0; $i < $maxRows; $i++) {
							echo "<tr>";

							// Skills
							if (isset($skills[$i])) {
								echo "<td colspan='2'></td>";
								echo "<td>{$skills[$i]['label']}</td>";
								foreach ($levels as $lvl) {
									$val = $student[$skills[$i]['key']] ?? '';
									$checked = ($val == $lvl) ? "checked" : "";
									echo "<td><input type='radio' value='{$lvl}' {$checked}></td>";
								}
							} else {
								echo "<td colspan='8'></td>"; // Empty cells if no skill
							}

							echo "<td></td>"; // separator

							// Behaviour
							if (isset($behaviour[$i])) {
								echo "<td>{$behaviour[$i]['label']}</td>";
								foreach ($levels as $lvl) {
									$val = $student[$behaviour[$i]['key']] ?? '';
									$checked = ($val == $lvl) ? "checked" : "";
									echo "<td><input type='radio' value='{$lvl}' {$checked}></td>";
								}
							} else {
								echo "<td colspan='6'></td>"; // Empty if no behaviour
							}

							echo "<td></td>"; // separator

							// Behaviour Contd
							if (isset($behaviour_contd[$i])) {
								echo "<td>{$behaviour_contd[$i]['label']}</td>";
								foreach ($levels as $lvl) {
									$val = $student[$behaviour_contd[$i]['key']] ?? '';
									$checked = ($val == $lvl) ? "checked" : "";
									echo "<td><input type='radio' value='{$lvl}' {$checked}></td>";
								}
							} else {
								echo "<td colspan='6'></td>"; // Empty if no behaviour contd
							}

							echo "</tr>";
						}
						?>
					</tbody>
				</table>
				<table class="table  table-bordered">
					<thead style="font-weight:bolder">
						<tr style="background-color:#000;">
							<th colspan="20">KEY TO SUBJECT GRADING:</th>

						</tr>
					</thead>
					<tbody class="table-head text-center" style="font-weight:bolder">

						<tr>
							<td>From</td>
							<td>To</td>
							<td>Grade</td>
							<td>Remark</td>
						</tr>

						<tr>
							<td>0.00%</td>
							<td>39.00%</td>
							<td>F</td>
							<td>FAIL</td>
						</tr>

						<tr>
							<td>40.00%</td>
							<td>44.00%</td>
							<td>E</td>
							<td>FAIR</td>
						</tr>

						<tr>
							<td>45.00%</td>
							<td>49.00%</td>
							<td>D</td>
							<td>PASS</td>
						</tr>

						<tr>
							<td>50.00%</td>
							<td>69.00%</td>
							<td>C</td>
							<td>GOOD</td>
						</tr>

						<tr>
							<td>70.00%</td>
							<td>79.00%</td>
							<td>B</td>
							<td>VERY GOOD</td>
						</tr>

						<tr>
							<td>80.00%</td>
							<td>100.00%</td>
							<td>A</td>
							<td>EXCELLENT</td>
							<td></td>

						</tr>


					</tbody>


					<?php echo $footer_content; ?>
			</div>
		</div>
		<div class="pagebreak"> </div>
		</div>
		</div>
<?php }
} ?>
<script>
function autoFitPrintPages() {
    const pages = document.querySelectorAll('.print-student-page');

    // A4 printable height in pixels (Chrome, 96dpi, 10mm margins)
    const A4_HEIGHT = 1122;

    pages.forEach(page => {
        page.style.transform = 'scale(1)';
        page.style.transformOrigin = 'top left';

        const originalHeight = page.scrollHeight;

        if (originalHeight <= A4_HEIGHT) {
            return; // Already fits, no scaling needed
        }

        // Calculate scale ratio
        let scale = A4_HEIGHT / originalHeight;

        // Prevent extreme shrinking
        scale = Math.max(scale, 0.72);

        page.style.transform = `scale(${scale})`;
    });
}
</script>
