<?php 
$widget = (is_superadmin_loggedin() ? 2 : 3);
$branch = $this->db->where('id', $branch_id)->get('branch')->row_array();
?>
<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open('exam/tabulation_sheet', array('class' => 'validate')); ?>
            <header class="panel-heading">
                <h4 class="panel-title"><?=translate('select_ground')?></h4>
            </header>
            <div class="panel-body">
                <div class="row mb-sm">
                    <?php if (is_superadmin_loggedin() ): ?>
                        <div class="col-md-3 mb-sm">
                            <div class="form-group">
                                <label class="control-label"><?=translate('branch')?> <span class="required">*</span></label>
                                <?php
                                    $arrayBranch = $this->app_lib->getSelectList('branch');
                                    echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id' required data-plugin-selectTwo data-width='100%'");
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('academic_year')?> <span class="required">*</span></label>
                            <?php
                                $arrayYear = array("" => translate('select'));
                                $years = $this->db->get('schoolyear')->result();
                                foreach ($years as $year){
                                    $arrayYear[$year->id] = $year->school_year;
                                }
                                echo form_dropdown("session_id", $arrayYear, set_value('session_id', get_session_id()), "class='form-control' required data-plugin-selectTwo data-width='100%'");
                            ?>
                        </div>
                    </div>
                    <div class="col-md-<?=$widget?> mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('exam')?> <span class="required">*</span></label>
                            <?php
                                if(!empty($branch_id)){
                                    $arrayExam = array("" => translate('select'));
                                    $exams = $this->db->get_where('exam', array('branch_id' => $branch_id,'session_id' => get_session_id()))->result();
                                    foreach ($exams as $exam){
                                        $arrayExam[$exam->id] = $this->application_model->exam_name_by_id($exam->id);
                                    }
                                } else {
                                    $arrayExam = array("" => translate('select_branch_first'));
                                }
                                echo form_dropdown("exam_id", $arrayExam, set_value('exam_id'), "class='form-control' id='exam_id' required data-plugin-selectTwo data-width='100%'");
                            ?>
                        </div>
                    </div>

                    <div class="col-md-3 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?=translate('class')?> <span class="required">*</span></label>
                            <?php
                                $arrayClass = $this->app_lib->getClass($branch_id);
                                echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' required data-plugin-selectTwo data-width='100%'");
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="submit" value="search" class="btn btn-default btn-block"><i class="fas fa-filter"></i> <?=translate('filter')?></button>
                    </div>
                </div>
            </div>
            <?php echo form_close();?>
        </section>

        <?php if (isset($get_subjects)) { ?>
            <section class="panel appear-animation" data-appear-animation="<?php echo $global_config['animations'];?>" data-appear-animation-delay="100">
                <div class="panel-body">
                    <div class="mt-sm mb-md">
                        <div class="export_title">
                            <?php 
                                echo translate('class') . ' : ' . get_type_name_by_id('class', set_value('class_id'));
                                echo ' - ' . $this->application_model->exam_name_by_id(set_value('exam_id')) . " Tabulation Sheet";
                            ?>
                        </div>

                        <table class="table table-bordered table-hover table-condensed mb-none" id="tableExport">
                            <thead class="text-dark">
                                <tr>
                                    <th><?=translate('position')?></th>
                                    <th><?=translate('students')?></th>
                                    <th><?=translate('register_no')?></th>
                                    <?php 
                                    foreach($get_subjects as $subject){
                                        $markDist = !empty($subject['mark_distribution']) ? json_decode($subject['mark_distribution'], true) : [];
                                        $fullMark = array_sum(array_column($markDist, 'full_mark'));
                                        echo '<th>' . $subject['subject_name'] . " (" . $fullMark . ')</th>';
                                    } 
                                    ?>
                                    <th><?=translate('total_marks')?></th>
                                    <th>Student Avg</th>
                                    <th>GPA</th>
                                    <th><?=translate('percentage')?></th>
                                    <th>Grade</th>
                                    <th><?=translate('result')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $studentArrayList = [];
                                $subjectTotals = [];
                                $subjectCounts = [];

                                foreach($students_list as $enroll) {
                                    $student = [];
                                    $student['student_name'] = $enroll->fullname;
                                    $student['register_no'] = $enroll->register_no;

                                    $totalMarks = 0;
                                    $totalGradePoint = 0;
                                    $totalSubjectsCounted = 0; // only offered subjects
                                    $subject_array_list = [];

                                    foreach ($get_subjects as $subject) {
                                        $this->db->where([
                                            'class_id' => set_value('class_id'),
                                            'exam_id' => set_value('exam_id'),
                                            'subject_id' => $subject['subject_id'],
                                            'student_id' => $enroll->student_id,
                                            'session_id' => set_value('session_id')
                                        ]);
                                        $getMark = $this->db->get('mark')->row_array();

                                        $fullMarkDistribution = !empty($subject['mark_distribution']) ? json_decode($subject['mark_distribution'], true) : [];
                                        $totalFullMark = array_sum(array_column($fullMarkDistribution, 'full_mark'));
                                        $totalPassMark = array_sum(array_column($fullMarkDistribution, 'pass_mark'));

                                        $subjectArr = ['totalFullMark' => $totalFullMark, 'pass_mark' => $totalPassMark];

                                        if(!empty($getMark)){
                                            $status = isset($getMark['subject_status']) ? $getMark['subject_status'] : 'present';

                                            if($status === 'not_offered'){
                                                $subjectArr['not_offered'] = true;
                                            } 
                                            elseif($status === 'absent'){
                                                $subjectArr['absent'] = true;
                                            } 
                                            else {
                                                $obtainedMarks = !empty($getMark['mark']) ? json_decode($getMark['mark'], true) : [];
                                                $totalObtained = !empty($obtainedMarks) ? array_sum(array_map('floatval', $obtainedMarks)) : 0;

                                                $subjectArr['totalObtained'] = $totalObtained;

                                                $totalMarks += $totalObtained;
                                                $totalSubjectsCounted++;

                                                if(!isset($subjectTotals[$subject['subject_id']])) $subjectTotals[$subject['subject_id']] = 0;
                                                if(!isset($subjectCounts[$subject['subject_id']])) $subjectCounts[$subject['subject_id']] = 0;
                                                $subjectTotals[$subject['subject_id']] += $totalObtained;
                                                $subjectCounts[$subject['subject_id']] += 1;

                                                $grade = $this->exam_model->getExam_grade($totalObtained, $branch_id);
                                                $totalGradePoint += $grade['grade_point'];
                                            }
                                        }

                                        $subject_array_list[] = $subjectArr;
                                    }

                                    $student['subject_array_list'] = $subject_array_list;
                                    $student['totalMarks'] = $totalMarks;
                                    $student['avg'] = $totalSubjectsCounted ? ($totalMarks / $totalSubjectsCounted) : 0;
                                    $student['GPA'] = $totalSubjectsCounted ? ($totalGradePoint / $totalSubjectsCounted) : 0;

                                    // percentage only for offered subjects
                                    $totalObtainedSum = array_sum(array_map(function($s){ return $s['totalObtained'] ?? 0; }, $subject_array_list));
                                    $totalFullMarkSum = array_sum(array_map(function($s){ return $s['not_offered'] ?? false ? 0 : $s['totalFullMark']; }, $subject_array_list));
                                    $student['percentage'] = $totalFullMarkSum > 0 ? ($totalObtainedSum / $totalFullMarkSum * 100) : 0;

                                    // Determine Grade
                                    if($student['percentage'] >= 80) $student['grade'] = 'A';
                                    elseif($student['percentage'] >= 60) $student['grade'] = 'B';
                                    elseif($student['percentage'] >= 50) $student['grade'] = 'C';
                                    elseif($student['percentage'] >= 40) $student['grade'] = 'D';
                                    else $student['grade'] = 'F';

                                    // Result based on Grade
                                    switch($student['grade']){
                                        case 'A': $student['result_pass'] = 'EXCELLENT'; break;
                                        case 'B': $student['result_pass'] = 'VERY GOOD'; break;
                                        case 'C': $student['result_pass'] = 'GOOD'; break;
                                        case 'D': $student['result_pass'] = 'PASS'; break;
                                        case 'F': $student['result_pass'] = 'FAIL'; break;
                                    }

                                    $studentArrayList[] = $student;
                                }

                                // Sort by total marks descending
                                usort($studentArrayList, function($a, $b){
                                    return $b['totalMarks'] <=> $a['totalMarks'];
                                });

                                $count = 1; $prevMarks = null; $rank = 1;
                                foreach($studentArrayList as $row1):
                                    if ($prevMarks !== null && $prevMarks != $row1['totalMarks']) {
                                        $rank = $count;
                                    }
                                    $prevMarks = $row1['totalMarks'];

                                    // Set row color based on grade
                                    $rowColor = '';
                                    switch($row1['grade']){
                                        case 'A': $rowColor = 'background-color:#28a745; color:white;'; break;
                                        case 'B': $rowColor = 'background-color:#85e085;'; break;
                                        case 'C': $rowColor = 'background-color:#fff3cd;'; break;
                                        case 'D': $rowColor = 'background-color:#ffc107;'; break;
                                        case 'F': $rowColor = 'background-color:#dc3545; color:white;'; break;
                                    }
                                ?>
                                <tr style="<?=$rowColor?>">
                                    <td><?=$rank?></td>
                                    <td><?=$row1['student_name']?></td>
                                    <td><?=$row1['register_no']?></td>
                                    <?php foreach($row1['subject_array_list'] as $subject): ?>
                                    <td style="<?=isset($subject['totalObtained']) && $subject['totalObtained'] < $subject['pass_mark'] ? 'color:red;font-weight:bold;' : ''?>">
                                        <?= isset($subject['not_offered']) ? 'N/A' : (isset($subject['totalObtained']) ? $subject['totalObtained'].'/'.$subject['totalFullMark'] : (isset($subject['absent']) ? translate('absent') : 'N/A')) ?>
                                    </td>
                                    <?php endforeach; ?>
                                    <td><?=$row1['totalMarks'].'/'.array_sum(array_map(function($s){ return $s['not_offered'] ?? false ? 0 : $s['totalFullMark']; }, $row1['subject_array_list']))?></td>
                                    <td><?=number_format($row1['avg'],2,'.','')?></td>
                                    <td><?=number_format($row1['GPA'],2,'.','')?></td>
                                    <td><?=number_format($row1['percentage'],2,'.','')?>%</td>
                                    <td><?=$row1['grade']?></td>
                                    <td>
<?php 
    $resultColor = '';
    switch($row1['result_pass']){
        case 'EXCELLENT': $resultColor = 'background-color:#28a745; color:white;'; break; // Green
        case 'VERY GOOD': $resultColor = 'background-color:#85e085; color:black;'; break;   // Light Green
        case 'GOOD': $resultColor = 'background-color:#fff3cd; color:black;'; break;       // Yellow
        case 'PASS': $resultColor = 'background-color:#ffc107; color:black;'; break;       // Orange
        case 'FAIL': $resultColor = 'background-color:#dc3545; color:white;'; break;       // Red
    }
?>
<span class="label" style="<?=$resultColor?>"><?=$row1['result_pass']?></span>
</td>
                                </tr>
                                <?php $count++; endforeach; ?>

                            </tbody>
                            <tfoot>
                                <tr style="background:#f3f3f3;font-weight:bold;text-align:center;">
                                    <?php
                                    $totalHeaderCols = 3 + count($get_subjects) + 6;
                                    $colIndex = 0;
                                    echo '<td>–</td>'; $colIndex++;
                                    echo '<td>SUBJECT AVERAGES</td><td>–</td>'; $colIndex += 2;

                                    foreach($get_subjects as $subject) {
                                        $avg = isset($subjectTotals[$subject['subject_id']]) && isset($subjectCounts[$subject['subject_id']])
                                            ? ($subjectTotals[$subject['subject_id']] / $subjectCounts[$subject['subject_id']])
                                            : 0;
                                        $avgColor = '';
                                        if($avg >= 75) $avgColor = 'background-color:#28a745; color:white;';
                                        elseif($avg >= 60) $avgColor = 'background-color:#85e085;';
                                        elseif($avg >= 50) $avgColor = 'background-color:#fff3cd;';
                                        elseif($avg >= 40) $avgColor = 'background-color:#ffc107;';
                                        else $avgColor = 'background-color:#dc3545; color:white;';
                                        echo '<td style="'.$avgColor.'">'.number_format($avg,2,'.','').'</td>';
                                        $colIndex++;
                                    }

                                    while($colIndex < $totalHeaderCols) {
                                        echo '<td></td>';
                                        $colIndex++;
                                    }
                                    ?>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </section>
        <?php } ?>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function () {
    $('#branch_id').on("change", function() {
        var branchID = $(this).val();
        getClassByBranch(branchID);
        getExamByBranch(branchID);
    });

    $('#tableExport').DataTable({
        "dom": '<"row"<"col-sm-6 mb-xs"B><"col-sm-6"f>><"table-responsive"t>p',
        "lengthChange": false,
        "pageLength": -1,
        "columnDefs": [{targets: [-1], orderable: false}],
        "buttons": [
            { extend: 'copyHtml5', text: '<i class="far fa-copy"></i>', titleAttr: 'Copy', exportOptions: {columns: ':visible'} },
            { extend: 'excelHtml5', text: '<i class="fa fa-file-excel"></i>', titleAttr: 'Excel', exportOptions: {columns: ':visible'} },
            { extend: 'csvHtml5', text: '<i class="fa fa-file-alt"></i>', titleAttr: 'CSV', exportOptions: {columns: ':visible'} },
            { extend: 'pdfHtml5', text: '<i class="fa fa-file-pdf"></i>', titleAttr: 'PDF', footer: true, exportOptions: {columns: ':visible'} },
            { extend: 'print', text: '<i class="fa fa-print"></i>', titleAttr: 'Print', footer: true, exportOptions: {columns: ':visible'} },
            { extend: 'colvis', text: '<i class="fas fa-columns"></i>', titleAttr: 'Columns', postfixButtons: ['colvisRestore'] },
        ]
    });
});
</script>
