<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li class="active">
				<a href="#list" data-toggle="tab">
					<i class="fas fa-list-ul"></i> <?= translate('template') . " " . translate('list') ?>
				</a>
			</li>
			<?php if (get_permission('marksheet_template', 'is_add')): ?>
				<li>
					<a href="#add" data-toggle="tab">
						<i class="far fa-edit"></i> <?= translate('add') . " " . translate('template') ?>
					</a>
				</li>
			<?php endif; ?>
		</ul>
		<div class="tab-content">
			<div class="tab-pane box active mb-md" id="list">
				<table class="table table-bordered table-hover mb-none table-condensed table-export">
					<thead>
						<tr>
							<th><?= translate('sl') ?></th>
							<?php if (is_superadmin_loggedin()): ?>
								<th><?= translate('branch') ?></th>
							<?php endif; ?>
							<th><?= translate('template') . " " . translate('name') ?></th>
							<th><?= translate('page_layout') ?></th>
							<th class="no-sort"><?= translate('background') . " " . translate('image') ?></th>
							<th><?= translate('created_at') ?></th>
							<th><?= translate('action') ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
						$count = 1;
						foreach ($certificatelist as $row):
						?>
							<tr>
								<td><?php echo $count++; ?></td>
								<?php if (is_superadmin_loggedin()): ?>
									<td><?php echo $row['branchname']; ?></td>
								<?php endif; ?>
								<td><?php echo $row['name']; ?></td>
								<td><?php
									if ($row['page_layout'] == 1) {
										echo "Portrait";
									} else {
										echo "Landscape";
									}
									?></td>
								<td>
									<?php
									$imgPath = 'uploads/marksheet/' . $row['background'];
									if (file_exists($imgPath) && !empty($row['background'])) {
										$imgPath = base_url($imgPath);
									} else {
										$imgPath = base_url('uploads/language_flags/defualt.png');
									}

									?>
									<img class="" src="<?= $imgPath ?>" height="50">
								</td>
								<td><?php echo _d($row['created_at']); ?></td>
								<td class="action">
									<!-- view link -->
									<a href="javascript:void(0);" class="btn btn-circle btn-default icon" data-toggle="tooltip" data-original-title="<?= translate('view') ?>"
										onclick="getMarksheet_template('<?= $row['id'] ?>');">
										<i class="fas fa-bars"></i>
									</a>
									<?php if (get_permission('marksheet_template', 'is_edit')) { ?>
										<a href="<?= base_url('marksheet_template/edit/' . $row['id']); ?>" class="btn btn-circle btn-default icon">
											<i class="fas fa-pen-nib"></i>
										</a>
									<?php }
									if (get_permission('marksheet_template', 'is_delete')) { ?>
										<!-- deletion link -->
										<?php echo btn_delete('marksheet_template/delete/' . $row['id']); ?>
									<?php } ?>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
			<?php if (get_permission('marksheet_template', 'is_add')): ?>
				<div class="tab-pane" id="add">
					<?php echo form_open($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data')); ?>
					<?php if (is_superadmin_loggedin()): ?>
						<div class="form-group">
							<label class="control-label col-md-3"><?= translate('branch') ?> <span class="required">*</span></label>
							<div class="col-md-8">
								<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' data-width='100%' onchange='getClassByBranch(this.value)'
									data-plugin-selectTwo  data-minimum-results-for-search='Infinity'");
								?>
								<span class="error"></span>
							</div>
						</div>
					<?php endif; ?>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('template') . " " . translate('name') ?> <span class="required">*</span></label>
						<div class="col-md-8">
							<input type="text" class="form-control" name="marksheet_template_name" value="" />
							<span class="error"></span>
						</div>
					</div>

<div class="form-group">
    <label class="col-md-3 control-label">
        <?= translate('assign_classes') ?> <span class="required">*</span>
    </label>
    <div class="col-md-8">
        <?php
        // 1. Get all classes
        $all_classes = $this->db
            ->select('id, name')
            ->from('class')
            ->order_by('name', 'ASC')
            ->get()
            ->result_array();

        // 2. Get classes already assigned in other templates
        $assigned_classes = $this->db
            ->select('class_ids')
            ->from('marksheet_template')
            ->where('class_ids IS NOT NULL')
            ->get()
            ->result_array();

        $used_class_ids = [];
        foreach ($assigned_classes as $row) {
            $ids = json_decode($row['class_ids'], true); // assuming class_ids is stored as JSON
            if (is_array($ids)) {
                $used_class_ids = array_merge($used_class_ids, $ids);
            }
        }

        // 3. Build dropdown options with classes not yet assigned
        $class_options = [];
        foreach ($all_classes as $class) {
            if (!in_array($class['id'], $used_class_ids)) {
                $class_options[$class['id']] = $class['name'];
            }
        }

        echo form_dropdown(
            "class_ids[]",
            $class_options,
            set_value('class_ids'),
            "class='form-control' multiple data-plugin-selectTwo data-width='100%'"
        );
        ?>
    </div>
</div>



					<div class="form-group">
						<label class="control-label col-md-3">Page Layout <span class="required">*</span></label>
						<div class="col-md-8">
							<?php
							$arrayType = array(
								'' => translate('select'),
								'1' => "Portrait",
								'2' => "Landscape",
							);
							echo form_dropdown("page_layout", $arrayType, set_value('page_layout'), "class='form-control' data-width='100%'
								data-plugin-selectTwo  data-minimum-results-for-search='Infinity'");
							?>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label">User Photo Style <span class="required">*</span></label>
						<div class="col-md-8">
							<div class="row">
								<div class="col-xs-6">
									<?php
									$arrayType = array(
										'1' => "Square",
										'2' => "Round"
									);
									echo form_dropdown("photo_style", $arrayType, set_value('photo_style'), "class='form-control' data-width='100%'
										data-plugin-selectTwo  data-minimum-results-for-search='Infinity'");
									?>
								</div>
								<div class="col-xs-6">
									<input type="text" class="form-control" name="photo_size" value="<?php echo set_value('photo_size', 120) ?>" placeholder="Photo Size (px)" />
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label">Layout Spacing <span class="required">*</span></label>
						<div class="col-md-8">
							<div class="row">
								<div class="col-xs-6">
									<input type="text" class="form-control" name="top_space" value="" placeholder="Top Space (px)" />
								</div>
								<div class="col-xs-6">
									<input type="text" class="form-control" name="bottom_space" value="" placeholder="Bottom Space (px)" />
								</div>
							</div>
						</div>
						<div class="mt-md col-md-offset-3 col-md-8">
							<div class="row">
								<div class="col-xs-6">
									<input type="text" class="form-control" name="right_space" value="" placeholder="Right Space (px)" />
								</div>
								<div class="col-xs-6">
									<input type="text" class="form-control" name="left_space" value="" placeholder="Left Space (px)" />
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('left') . " " . translate('signature') ?></label>
						<div class="col-md-8">
							<div class="fileupload fileupload-new" data-provides="fileupload">
								<div class="input-append">
									<div class="uneditable-input">
										<i class="fas fa-file fileupload-exists"></i>
										<span class="fileupload-preview"></span>
									</div>
									<span class="btn btn-default btn-file">
										<span class="fileupload-exists">Change</span>
										<span class="fileupload-new">Select file</span>
										<input type="file" name="left_signature_file" />
									</span>
									<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('middle') . " " . translate('signature') ?></label>
						<div class="col-md-8">
							<div class="fileupload fileupload-new" data-provides="fileupload">
								<div class="input-append">
									<div class="uneditable-input">
										<i class="fas fa-file fileupload-exists"></i>
										<span class="fileupload-preview"></span>
									</div>
									<span class="btn btn-default btn-file">
										<span class="fileupload-exists">Change</span>
										<span class="fileupload-new">Select file</span>
										<input type="file" name="middle_signature_file" />
									</span>
									<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('right') . " " . translate('signature') ?></label>
						<div class="col-md-8">
							<div class="fileupload fileupload-new" data-provides="fileupload">
								<div class="input-append">
									<div class="uneditable-input">
										<i class="fas fa-file fileupload-exists"></i>
										<span class="fileupload-preview"></span>
									</div>
									<span class="btn btn-default btn-file">
										<span class="fileupload-exists">Change</span>
										<span class="fileupload-new">Select file</span>
										<input type="file" name="right_signature_file" />
									</span>
									<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('logo') . " " . translate('image') ?></label>
						<div class="col-md-8">
							<div class="fileupload fileupload-new" data-provides="fileupload">
								<div class="input-append">
									<div class="uneditable-input">
										<i class="fas fa-file fileupload-exists"></i>
										<span class="fileupload-preview"></span>
									</div>
									<span class="btn btn-default btn-file">
										<span class="fileupload-exists">Change</span>
										<span class="fileupload-new">Select file</span>
										<input type="file" name="logo_file" />
									</span>
									<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('background') . " " . translate('image') ?></label>
						<div class="col-md-8">
							<div class="fileupload fileupload-new" data-provides="fileupload">
								<div class="input-append">
									<div class="uneditable-input">
										<i class="fas fa-file fileupload-exists"></i>
										<span class="fileupload-preview"></span>
									</div>
									<span class="btn btn-default btn-file">
										<span class="fileupload-exists">Change</span>
										<span class="fileupload-new">Select file</span>
										<input type="file" name="background_file" />
									</span>
									<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
								</div>
							</div>
							<span class="error"></span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('header') . " " . translate('content') ?> <span class="required">*</span></label>
						<div class="col-md-8">
							<textarea name="header_content" class="form-control texteEditor" id="texteEditor1" rows="10"></textarea>
							<span class="error"></span>
							<div class="studenttags">
								<?php
								$tagsList = $this->marksheet_template_model->tagsList();
								foreach ($tagsList as $key => $value) {
								?>
									<a data-value=" <?= $value ?> " class="btn btn-default mt-sm btn-xs btn_tag1"><?= $value ?></a>
								<?php } ?>
							</div>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('footer') . " " . translate('content') ?> <span class="required">*</span></label>
						<div class="col-md-8">
							<textarea name="footer_content" class="form-control texteEditor" id="texteEditor2" rows="10"></textarea>
							<span class="error"></span>
							<div class="studenttags">
								<?php
								foreach ($tagsList as $key => $value) {
								?>
									<a data-value=" <?= $value ?> " class="btn btn-default mt-sm btn-xs btn_tag2"><?= $value ?></a>
								<?php } ?>
							</div>
						</div>
					</div>

					<div class="form-group">
						<div class="col-md-offset-3 col-md-8">
							<div class="checkbox-replace">
								<label class="i-checks">
									<input type="checkbox" name="attendance_percentage" value="true" checked=""><i></i> <?php echo translate('attendance') . " " . translate('percentage'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="grading_scale" value="true" checked=""><i></i> <?php echo translate('grading_scale'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="position" value="true" checked=""><i></i> <?php echo translate('position'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="cumulative_average" value="true" checked=""><i></i> <?php echo translate('cumulative') . " " . translate('average'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="class_average" value="true" checked=""><i></i> <?php echo translate('class') . " " . translate('average'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="subject_position" value="true" checked=""><i></i> <?php echo translate('subject') . " " . translate('position'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm">
								<label class="i-checks">
									<input type="checkbox" name="remark" value="true" checked=""><i></i> <?php echo translate('remark'); ?>
								</label>
							</div>
							<div class="checkbox-replace mt-sm mb-lg">
								<label class="i-checks">
									<input type="checkbox" name="result" value="true" checked=""><i></i> <?php echo translate('result'); ?>
								</label>
							</div>
						</div>
					</div>

					<footer class="panel-footer">
						<div class="row">
							<div class="col-md-offset-3 col-md-2">
								<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
									<i class="fas fa-plus-circle"></i> <?= translate('save') ?>
								</button>
							</div>
						</div>
					</footer>
					<?php echo form_close(); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>

<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide payroll-t-modal" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title"><i class="fas fa-bars"></i> <?php echo translate('template') . " " . translate('view'); ?></h4>
		</header>
		<div class="panel-body">
			<div id="quick_view"></div>
		</div>
		<footer class="panel-footer">
			<div class="row">
				<div class="col-md-12 text-right">
					<button class="btn btn-default modal-dismiss"><?php echo translate('close'); ?></button>
				</div>
			</div>
		</footer>
	</section>
</div>

<script type="text/javascript">
	$(document).ready(function() {
		if ($(".texteEditor").length) {
			$('.texteEditor').summernote({
				fontNames: ['Arial', 'Arial Black', 'Consolas', 'Tahoma', 'Times New Roman', 'Great Vibes', 'Pinyon Script', 'Parisienne'],
				fontNamesIgnoreCheck: ['Great Vibes', 'Pinyon Script', 'Parisienne'],
				fontSizes: ['8', '9', '10', '11', '12', '14', '18', '24', '28', '36', '48', '64', '82'],
				height: 220,
				toolbar: [
					["style", ["style"]],
					["name", ["fontname", "fontsize", "height"]],
					["font", ["bold", "italic", "underline", "clear"]],
					["color", ["color"]],
					["para", ["ul", "ol", "paragraph"]],
					["insert", ["link", "table"]],
					["misc", ["fullscreen", "undo", "codeview"]]
				]
			});
		}

		$('.btn_tag1').on('click', function() {
			var txtToAdd = $(this).data("value");
			$('#texteEditor1').summernote('editor.insertText', txtToAdd);
		});
		$('.btn_tag2').on('click', function() {
			var txtToAdd = $(this).data("value");
			$('#texteEditor2').summernote('editor.insertText', txtToAdd);
		});
	});

	function getMarksheet_template(id) {
		$.ajax({
			url: base_url + 'marksheet_template/getCertificate',
			type: 'POST',
			data: {
				'id': id
			},
			dataType: "html",
			success: function(data) {
				$('#quick_view').html(data);
				mfp_modal('#modal');
			}
		});
	}
</script>