<section class="panel">
    <header class="panel-heading">
        <h4 class="panel-title"><i class="fas fa-history"></i> Transaction History</h4>
    </header>

    <div class="panel-body">
        <table class="table table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Wallet Deposit</th>
                    <th>Payment Method</th>
                    <!-- <th>Reference</th> -->
                    <th>Status</th>
                </tr>
            </thead>

            <tbody>
                <?php 
                $count = 1;
                if (!empty($deposits)):
                    foreach ($deposits as $row):  
                ?>
                <tr>
                    <td><?= $count++; ?></td>
                    <td><?= date('d M Y', strtotime($row['date'])); ?></td>
                    <td><strong><?= number_format($row['amount']); ?></strong></td>
                    <td>Student Account</td>
                    <td><?php if ($row['pay_via'] == 9): ?>
                         <span>PayStack</span><?php endif; ?></td>
                    <!-- <td><?= $row['remarks']; ?></td> -->
                    <td>
                        <?php if ($row['status'] == 'Successful'): ?>
                            <span class="label label-success">Successful</span>
                        <?php else: ?>
                            <span class="label label-danger">Failed</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php 
                    endforeach;
                else:
                ?>
                <tr>
                    <td colspan="6" class="text-center text-danger">
                        No Deposit Records Found
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>

        </table>
    </div>
</section>
