<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Cmas_behaviour_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getCmasStudentBehaviour($classID, $sectionID, $branchID)
    {
        $role = 7;
        $active = 1;
        $sql = "SELECT `enroll`.`id` as `enroll_id`,`enroll`.`roll`,`student`.`first_name`,`student`.`last_name`,`student`.`id` as `student_id`,`student`.`register_no`, `student`.`gender`,`cmas_behaviour`.`id` as `btt_id`,`cmas_behaviour`.`leadership` as `behav_leadership`,`cmas_behaviour`.`skilll_hand` as `behav_skilll_hand`,`cmas_behaviour`.`nonverbal_skill` as `behav_nonverbal_skill`,`cmas_behaviour`.`materials` as `behav_materials`,`cmas_behaviour`.`punctuality` as `behav_punctuality`,`cmas_behaviour`.`politeness` as `behav_politeness`,`cmas_behaviour`.`cmaskill5` as `behav_cmaskill5`,`cmas_behaviour`.`cmaskill6` as `behav_cmaskill6`,`cmas_behaviour`.`cmaskill4` as `behav_cmaskill4`,`cmas_behaviour`.`cmaskill3` as `behav_cmaskill3`,`cmas_behaviour`.`cmaskill2` as `behav_cmaskill2`,`cmas_behaviour`.`cmaskill1` as `behav_cmaskill1`,`cmas_behaviour`.`beha_help` as `behav_beha_help`,`cmas_behaviour`.`perseverance` as `behav_perseverance`,`cmas_behaviour`.`neatness` as `behav_neatness`,`cmas_behaviour`.`honesty` as `behav_honesty`,`cmas_behaviour`.`cooperation` as `behav_cooperation`,`cmas_behaviour`.`speaking` as `behav_speaking`,`cmas_behaviour`.`cmabehav5` as `behav_cmabehav5`,`cmas_behaviour`.`cmabehav6` as `behav_cmabehav6`,`cmas_behaviour`.`cmabehav4` as `behav_cmabehav4`,`cmas_behaviour`.`cmabehav3` as `behav_cmabehav3`,`cmas_behaviour`.`cmabehav2` as `behav_cmabehav2`,`cmas_behaviour`.`cmabehav1` as `behav_cmabehav1`,`cmas_behaviour`.`emotional_stability` as `behav_emotional_stability`,`cmas_behaviour`.`attitude` as `behav_attitude`,`cmas_behaviour`.`orderliness` as `behav_orderliness`,`cmas_behaviour`.`behavcontd3` as `behav_behavcontd3`,`cmas_behaviour`.`behavcontd2` as `behav_behavcontd2`,`cmas_behaviour`.`behavcontd1` as `behav_behavcontd1`,`cmas_behaviour`.`teachers_comment` as `behav_teachers_comment` FROM `enroll` LEFT JOIN `student` ON `student`.`id` = `enroll`.`student_id` LEFT JOIN `cmas_behaviour` ON `cmas_behaviour`.`enroll_id` = `enroll`.`id` INNER JOIN `login_credential` ON `login_credential`.`user_id` = `enroll`.`id` WHERE `enroll`.`class_id` = " . $this->db->escape($classID) . " AND `enroll`.`section_id` = " . $this->db->escape($sectionID) . " AND `enroll`.`branch_id` = " . $this->db->escape($branchID) . " AND `enroll`.`session_id` = " . $this->db->escape(get_session_id()) . " AND `login_credential`.`role` = " . $role . " AND `login_credential`.`active` = " . $active;
        return $this->db->query($sql)->result_array();

    }


 
    public function getExamAttendence($classID, $sectionID, $examID, $subjectID, $branchID)
    {
        $sql = "SELECT enroll.student_id,enroll.roll,student.first_name,student.last_name,student.register_no,exam_attendance.id as `atten_id`,
        exam_attendance.status as `att_status`,exam_attendance.remark as `att_remark` FROM `enroll` LEFT JOIN student ON
        student.id = enroll.student_id LEFT JOIN exam_attendance ON exam_attendance.student_id = student.id AND exam_attendance.exam_id = " .
        $this->db->escape($examID) . " AND exam_attendance.subject_id = " . $this->db->escape($subjectID) .
        " WHERE enroll.class_id = " . $this->db->escape($classID) . " AND enroll.section_id = " . $this->db->escape($sectionID) .
        " AND enroll.branch_id = " . $this->db->escape($branchID) . " AND enroll.session_id = " . $this->db->escape(get_session_id());
        return $this->db->query($sql)->result_array();
    }

    public function getStudentList($branch_id, $class_id, $section_id)
    {
        $this->db->select('e.id as enroll_id,e.roll,s.first_name,s.last_name,s.register_no');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 's.id = e.student_id', 'left');
        $this->db->where('e.class_id', $class_id);
        $this->db->where('e.section_id', $section_id);
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', get_session_id());
        return $this->db->get()->result_array();
    }

 
    public function getExamReport($data)
    {
        $sql = "SELECT ea.*, s.first_name, s.last_name, s.register_no, s.category_id, e.roll, sb.name as subject_name FROM exam_attendance as ea LEFT JOIN enroll as e ON e.student_id = ea.student_id LEFT JOIN student as s ON s.id = ea.student_id LEFT JOIN subject as sb ON sb.id = ea.subject_id WHERE ea.exam_id = " . $this->db->escape($data['exam_id']) . " AND ea.subject_id = " . $this->db->escape($data['subject_id']) . " AND ea.branch_id = " . $this->db->escape($data['branch_id']) . " AND e.class_id = " . $this->db->escape($data['class_id']) . " AND e.section_id = " . $this->db->escape($data['section_id']) . " AND e.session_id = " . $this->db->escape(get_session_id());
        return $this->db->query($sql)->result_array();
    }

    // check attendance by staff id and date
    public function get_attendance_by_date($studentID, $date)
    {
        $sql = "SELECT `student_attendance`.* FROM `student_attendance` WHERE `enroll_id` = " . $this->db->escape($studentID) . " AND DATE(`date`) = " . $this->db->escape($date);
        return $this->db->query($sql)->row_array();
    }





    public function getDailyStudentReport($branchID = '', $date = '')
    {
        $sql = "SELECT class.name as `class_name`,section.name as `section_name`, SUM(CASE WHEN `status` = 'P' THEN 1 ELSE 0 END) AS 'present',SUM(CASE WHEN `status` = 'A' THEN 1 ELSE 0 END) AS 'absent',SUM(CASE WHEN `status` = 'L' THEN 1 ELSE 0 END) AS 'late',SUM(CASE WHEN `status` = 'HD' THEN 1 ELSE 0 END) AS 'half_day' FROM `student_attendance` JOIN `enroll` on student_attendance.enroll_id=enroll.id INNER JOIN `sections_allocation` on (enroll.class_id=sections_allocation.class_id and enroll.section_id=sections_allocation.section_id) inner join `class` on class.id=sections_allocation.class_id INNER JOIN `section` on section.id=sections_allocation.section_id WHERE `enroll`.`session_id`=" . $this->db->escape(get_session_id()) . " AND enroll.branch_id = " . $this->db->escape($branchID) . " AND student_attendance.date = " . $this->db->escape($date) . " GROUP BY sections_allocation.id ORDER BY sections_allocation.class_id";
        $query = $this->db->query($sql);
        $count_studentattendance = $query->result();
        return $count_studentattendance;
    }
}
