<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Exam_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    } 

    public function getExamByID($id = null)
    {
        $sql = "SELECT `e`.*, `exam_term`.`name` as `term_name`, `b`.`name` as `branch_name` FROM `exam` as `e` INNER JOIN `branch` as `b` ON `b`.`id` = `e`.`branch_id` LEFT JOIN `exam_term` ON `exam_term`.`id` = `e`.`term_id` WHERE `e`.`id` = {$this->db->escape($id)}";
        return $this->db->query($sql)->row();
    }



       public function searchExamPrincipalStudentsByRank($class_ID = '', $section_ID = '', $session_ID = '', $exam_ID = '', $branch_id = '')
    {
        $this->db->select('e.*,CONCAT_WS(" ",first_name, last_name) as fullname,register_no,c.name as class_name,se.name as section_name, princi.comment as principal_comment, cma_principal_comment.rank,cma_principal_comment.principal_comment,cma_principal_comment.teacher_comment, behav.teachers_comment as teacher_comm');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
         $this->db->join('mark as mrk', 'e.student_id=mrk.student_id', 'left');
        $this->db->join('login_credential as l', 'l.user_id = mrk.student_id and l.role = 7 and l.active = 1' , 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('exam as ex', 'ex.id = mrk.exam_id', 'inner');
        $this->db->join('exam_principal_comment as princi', 'princi.id = e.branch_id', 'left');
        $this->db->join('cmas_behaviour as behav', 'behav.enroll_id = s.id', 'left');
        $this->db->join('section as se', 'e.section_id=se.id', 'left');
       
        $this->db->join('cma_principal_comment', 'cma_principal_comment.enroll_id = e.id and cma_principal_comment.exam_id = ' . $this->db->escape($exam_ID), 'left');
        $this->db->where('e.class_id', $class_ID);
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', $session_ID);
        $this->db->where_in('mrk.exam_id', $examID);
        $this->db->group_by('mrk.student_id');
        $this->db->order_by('cma_principal_comment.rank', 'ASC');
        $this->db->where('l.active', 1);
        return $this->db->get()->result();
    }




    public function searchExamClassStudentsByRank($class_ID = '', $section_ID = '', $session_ID = '', $exam_ID = '', $branch_id = '')
    {
        $this->db->select('e.*,CONCAT_WS(" ",first_name, last_name) as fullname,register_no,c.name as class_name,se.name as class_name,exam_class_rank.rank');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
         $this->db->join('mark as mrk', 'e.student_id=mrk.student_id', 'left');
        $this->db->join('login_credential as l', 'l.user_id = s.id and l.role = 7 and l.active = 1' , 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('exam as ex', 'ex.id = mrk.exam_id', 'inner');
        $this->db->join('section as se', 'e.section_id=se.id', 'left');
        $this->db->join('exam_class_rank', 'exam_class_rank.enroll_id=e.id and exam_class_rank.exam_id = ' . $this->db->escape($exam_ID), 'left');
                $this->db->where('e.class_id', $class_ID);
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', $session_ID);
        $this->db->where_in('mrk.exam_id', $examID);
        $this->db->order_by('mrk.exam_id', 'ASC');
         $this->db->group_by('mrk.student_id');
        $this->db->where('mrk.class_id',$class_ID);
       
        return $this->db->get()->result();
    }



       public function searchExamSectionStudentsByRank($class_ID = '', $section_ID = '', $session_ID = '', $exam_ID = '', $branch_id = '')
    {
        $this->db->select('e.*,CONCAT_WS(" ",first_name, last_name) as fullname,register_no,c.name as class_name,se.name as section_name,exam_section_rank.rank');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('login_credential as l', 'l.user_id = s.id and l.role = 7 and l.active = 1' , 'inner');
        $this->db->join('class as c', 'e.class_id = c.id', 'left');
        $this->db->join('section as se', 'e.section_id=se.id', 'left');
        $this->db->join('exam_section_rank', 'exam_section_rank.enroll_id=e.id and exam_section_rank.exam_id = ' . $this->db->escape($exam_ID), 'left');
        $this->db->where('e.class_id', $class_ID);
        if (!empty($section_ID)) {
            $this->db->where('e.section_id', $section_ID);
        }
        $this->db->where('e.branch_id', $branch_id);
        $this->db->where('e.session_id', $session_ID);
        $this->db->order_by('exam_section_rank.rank', 'ASC');
        $this->db->where('l.active', 1);
        $this->db->group_by('s.id');
        return $this->db->get()->result();
    }

    public function getExamList()
    {
        $this->db->select('e.*,b.name as branch_name');
        $this->db->from('exam as e');
        $this->db->join('branch as b', 'b.id = e.branch_id', 'left');
        if (!is_superadmin_loggedin()) {
            $this->db->where('e.branch_id', get_loggedin_branch_id());
        }
        $this->db->where('e.session_id', get_session_id());
        $this->db->order_by('e.id', 'asc');
        return $this->db->get()->result_array();
    }

    public function exam_save($data)
    {
        $arrayExam = array(
            'name' => $data['name'],
            'branch_id' => $this->application_model->get_branch_id(),
            'term_id' => $data['term_id'],
            'type_id' => $data['type_id'],
            'mark_distribution' => json_encode($data['mark_distribution']),
            'remark' => $data['remark'],
            'session_id' => get_session_id(),
            'status' => (isset($_POST['exam_publish']) ? 1 : 0),
            'publish_result' => 0,
        );
        if (!isset($data['exam_id'])) {
            $this->db->insert('exam', $arrayExam);
        } else {
            $this->db->where('id', $data['exam_id']);
            $this->db->update('exam', $arrayExam);
        }
    }




       public function PrincipalCommentSave($post)
    {
        $arrayPrincipal = array(
            'comment' => $post['comment'],
            'branch_id' => $this->application_model->get_branch_id(),
            'session' => get_session_id(),
        );
        if (!isset($post['comment_id'])) {
            $this->db->insert('exam_principal_comment', $arrayPrincipal);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['comment_id']);
            $this->db->update('exam_principal_comment', $arrayPrincipal);
        }
    }

    public function termSave($post)
    {
        $arrayTerm = array(
            'name' => $post['term_name'],
            'branch_id' => $this->application_model->get_branch_id(),
            'session_id' => get_session_id(),
        );
        if (!isset($post['term_id'])) {
            $this->db->insert('exam_term', $arrayTerm);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['term_id']);
            $this->db->update('exam_term', $arrayTerm);
        }
    }




    public function hallSave($post)
    {
        $arrayHall = array(
            'hall_no' => $post['hall_no'],
            'seats' => $post['no_of_seats'],
            'branch_id' => $this->application_model->get_branch_id(),
        );
        if (!isset($post['hall_id'])) {
            $this->db->insert('exam_hall', $arrayHall);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $post['hall_id']);
            $this->db->update('exam_hall', $arrayHall);
        }
    }

    public function gradeSave($data)
    {
        $arrayData = array(
            'branch_id' => $this->application_model->get_branch_id(),
            'name' => $data['name'],
            'grade_point' => $data['grade_point'],
            'lower_mark' => $data['lower_mark'],
            'upper_mark' => $data['upper_mark'],
            'remark' => $data['remark'],
        );
        // posted all data XSS filtering
        if (!isset($data['grade_id'])) {
            $this->db->insert('grade', $arrayData);
        } else {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $data['grade_id']);
            $this->db->update('grade', $arrayData);
        }
    }




     public function ordinal($number)
    {
        $ends = array('th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th');
        if ((($number % 100) >= 11) && (($number % 100) <= 13)) {
            return $number . 'th';
        } else {
            return $number . $ends[$number % 10];
        }
    }




       public function getExamClassAverage($examID, $sessionID, $subjectID = '')
    {
       $this->db->select('m.mark as get_mark,IFNULL(m.absent, 0) as get_abs');
        $this->db->from('mark as m');
        if (is_array($examID)) {
            $this->db->where_in('m.exam_id', $examID);
        } else {
            $this->db->where('m.exam_id', $examID);
        }
        $this->db->where('m.session_id', $sessionID);
        $this->db->where('m.subject_id', $subjectID);
        $getMarksList = $this->db->get()->result_array();
        $count = count($getMarksList);
        $grand_obtain_marks = 0;
        foreach ($getMarksList as $row) {
            $obtainedMark = json_decode($row['get_mark'], true);
            $total_obtain_marks = 0;
            foreach ($obtainedMark as $i => $val) {
                $obtained_mark = floatval($obtainedMark[$i]);
                if ($row['get_abs'] != 'on') {
                    $total_obtain_marks += $obtained_mark;
                }
            }
            $grand_obtain_marks += $total_obtain_marks;
        }
        if (!empty($grand_obtain_marks)) {
            $grand_percentage = $grand_obtain_marks / $count;
        } else {
            $grand_percentage = 0;
        }

        $cumulative = number_format($grand_percentage, 2, '.', '');
        return $cumulative . "";
    }




 public function getExamSubjectPosition($classID = '', $sectionID = '', $examID = [], $sessionID = '', $subjectID = '', $mark = 0)
    {
        $this->db->select('student_id as id');
        $this->db->where('class_id', $classID);
        $this->db->where('section_id', $sectionID);
        $this->db->where('session_id', $sessionID);
        $enroll = $this->db->get('enroll')->result();
        $grand_obtain_marks = [];
        foreach ($enroll as $key => $value) {
            $this->db->select('m.mark as get_mark,IFNULL(m.absent, 0) as get_abs');
            $this->db->from('mark as m');
            $this->db->join('enroll as enr', 'enr.student_id = m.student_id', 'inner');
            $this->db->where('m.student_id = enr.student_id');
            $this->db->where_in('m.exam_id', $examID);
            $this->db->where('m.student_id', $value->id);
            $this->db->where('m.session_id', $sessionID);
            $this->db->where('m.subject_id', $subjectID);
            $getMarksList = $this->db->get()->result_array();
            $obtain_marks = 0;
            foreach ($getMarksList as $row) {
                $obtainedMark = json_decode($row['get_mark'], true);
                $total_obtain_marks = 0;
                foreach ($obtainedMark as $i => $val) {
                    $obtained_mark = floatval($obtainedMark[$i]);
                    if ($row['get_abs'] != 'on') {
                        $obtain_marks += $obtained_mark;
                    }
                }
            }
            $grand_obtain_marks[] = $obtain_marks;
        }
        array_multisort($grand_obtain_marks, SORT_DESC, $grand_obtain_marks);
        $f = array_keys($grand_obtain_marks, $mark);
        if (empty($f)) {
            return 'N/A';
        } else {
            return $this->ordinal($f[0] + 1);
        }
    }


    public function getExam_grade($mark, $branch_id)
    {
        $this->db->where('branch_id', $branch_id);
        $query = $this->db->get('grade');
        $grades = $query->result_array();
        foreach ($grades as $row) {
            if ($mark >= $row['lower_mark'] && $mark <= $row['upper_mark']) {
                return $row;
            }
        }
    }

    public function getSubjectList($examID, $classID, $sectionID, $sessionID)
    {
        $branchID = $this->application_model->get_branch_id();
        $this->db->select('t.*,s.name as subject_name');
        $this->db->from('timetable_exam as t');
        $this->db->join('subject as s', 's.id = t.subject_id', 'inner');
        $this->db->where('t.exam_id', $examID);
        $this->db->where('t.class_id', $classID);
        $this->db->where('t.section_id', $sectionID);
        $this->db->where('t.session_id', $sessionID); 
        $this->db->where('t.branch_id', $branchID);
        $this->db->group_by('t.subject_id');
        return $this->db->get()->result_array();
    }

    public function getTimetableDetail($classID, $sectionID, $examID, $subjectID)
    {
        $this->db->select('timetable_exam.mark_distribution');
        $this->db->where('class_id', $classID);
        $this->db->where('section_id', $sectionID);
        $this->db->where('exam_id', $examID);
        $this->db->where('subject_id', $subjectID);
        $this->db->where('session_id', get_session_id());
        return $this->db->get('timetable_exam')->row_array();
    }

    public function getMarkAndStudent($branchID, $classID, $sectionID, $examID, $subjectID)
    {
        $this->db->select('en.*,st.first_name,st.last_name,st.register_no,st.category_id,m.mark as get_mark,IFNULL(m.absent, 0) as get_abs,subject.name as subject_name');
        $this->db->from('enroll as en');
        $this->db->join('student as st', 'st.id = en.student_id', 'inner');
        $this->db->join('login_credential as l', 'l.user_id = st.id and l.role = 7 and l.active = 1' , 'inner');
        $this->db->join('mark as m', 'm.student_id = en.student_id and m.class_id = en.class_id and m.section_id = en.section_id and m.exam_id = ' . $this->db->escape($examID) . ' and m.subject_id = ' . $this->db->escape($subjectID), 'left');
        $this->db->join('subject', 'subject.id = m.subject_id', 'left');
        $this->db->where('en.class_id', $classID);
        $this->db->where('en.section_id', $sectionID);
        $this->db->where('en.branch_id', $branchID);
        $this->db->where('en.session_id', get_session_id());
        $this->db->order_by('en.roll', 'ASC');
        return $this->db->get()->result_array();
    }

    public function getExamStudentReportCard($studentID, $examID, $sessionID)
    {
       $result = array();
        $this->db->select('enroll.roll,enroll.id as enrollID,enroll.class_id,enroll.section_id,enroll.branch_id,student.*,c.name as class_name,attend.days as student_days,attend.attendance as student_attend,sc.name as category_name,beha.cmaskill5 as behav_cmaskill5,beha.cmaskill6 as behav_cmaskill6,beha.cmaskill4 as behav_cmaskill4,beha.cmaskill3 as behav_cmaskill3,beha.cmaskill2 as behav_cmaskill2,beha.cmaskill1 as behav_cmaskill1,beha.cmabehav5 as behav_cmabehav5,beha.cmabehav6 as behav_cmabehav6,beha.cmabehav4 as behav_cmabehav4,beha.cmabehav3 as behav_cmabehav3,beha.cmabehav2 as behav_cmabehav2,beha.cmabehav1 as behav_cmabehav1,beha.behavcontd3 as behav_behavcontd3,beha.behavcontd2 as behav_behavcontd2,beha.behavcontd1 as behav_behavcontd1,commprincipal.teacher_comment as cteachercomm,commcreate.comment as cprincipalcomm, sectionrank.rank as secrank, classrank.rank as clrank, beha.teachers_comment as behav_teachers_comment,l.username as student_username,se.name as section_name,IFNULL(parent.father_name,"N/A") as father_name,IFNULL(parent.mother_name,"N/A") as mother_name');
        $this->db->from('enroll');
        $this->db->join('student', 'student.id = enroll.student_id', 'inner');
        $this->db->join('student_category as sc', 'student.category_id=sc.id', 'left');
        $this->db->join('cmas_behaviour as beha', 'enroll.student_id=beha.enroll_id', 'left');
        $this->db->join('cmas_attendance as attend', 'enroll.student_id=attend.enroll_id', 'left');
        $this->db->join('login_credential as l', 'l.user_id = student.id and l.role = 7 and l.active = 1', 'inner');

        $this->db->join('cma_principal_comment as commprincipal', 'enroll.student_id=commprincipal.enroll_id', 'left');
        $this->db->join('exam_principal_comment as commcreate', 'commprincipal.principal_comment=commcreate.id', 'left');

        $this->db->join('exam_class_rank as classrank', 'enroll.student_id=classrank.enroll_id', 'left');
        $this->db->join('exam_section_rank as sectionrank', 'enroll.student_id=sectionrank.enroll_id', 'left');

        $this->db->join('class as c', 'c.id = enroll.class_id', 'left');
        $this->db->join('section as se', 'se.id = enroll.section_id', 'left');
        $this->db->join('parent', 'parent.id = student.parent_id', 'left');
        $this->db->join('mark as m', 'enroll.student_id = m.student_id', 'inner');
        $this->db->where('m.student_id = enroll.student_id');


        $this->db->where('enroll.student_id', $studentID);
        $this->db->where('enroll.session_id', $sessionID);
        $result['student'] = $this->db->get()->row_array();

        $this->db->select('m.mark as get_mark,IFNULL(m.absent, 0) as get_abs,subject.id as subject_id, subject.name as subject_name, te.mark_distribution');
        $this->db->from('mark as m');
        $this->db->join('subject', 'subject.id = m.subject_id', 'left');
        $this->db->join('timetable_exam as te', 'te.exam_id = m.exam_id and te.class_id = m.class_id and te.section_id = m.section_id and te.subject_id = m.subject_id', 'left');
        $this->db->where('m.exam_id', $examID);
        $this->db->where('m.student_id', $studentID);
        $this->db->where('m.session_id', $sessionID);
        $this->db->group_by('m.subject_id');
        $this->db->order_by('subject.id', 'ASC');
        $result['exam'] = $this->db->get()->result_array();
        return $result;
    }

}
